"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentRollbackModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/components/agent_rollback_modal/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AgentRollbackModal = ({
  agents,
  agentCount,
  onClose
}) => {
  var _agents$0$upgrade, _agents$0$upgrade$rol, _agents$0$upgrade$rol2;
  const confirmModalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const [isSubmitting, setIsSubmitting] = (0, _react.useState)(false);
  const isSingleAgent = Array.isArray(agents) && agents.length === 1;
  async function onSubmit() {
    try {
      setIsSubmitting(true);
      if (isSingleAgent) {
        await (0, _hooks.sendPostAgentRollback)(agents[0].id);
      } else {
        await (0, _hooks.sendPostBulkAgentRollback)({
          agents: Array.isArray(agents) ? agents.map(agent => agent.id) : agents,
          includeInactive: true
        });
      }
      notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.fleet.rollbackAgents.successNotificationTitle', {
        defaultMessage: 'Rolling back {agentCount, plural, one {agent} other {agents}}',
        values: {
          agentCount
        }
      }));
    } catch (err) {
      notifications.toasts.addError(err, {
        title: _i18n.i18n.translate('xpack.fleet.agentList.rollbackAgents.errorNotificationTitle', {
          defaultMessage: 'Failed to roll back {agentCount, plural, one {agent} other {agents}}',
          values: {
            agentCount
          }
        })
      });
    } finally {
      setIsSubmitting(false);
      onClose();
    }
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "data-test-subj": "agentRollbackModal",
    "aria-labelledby": confirmModalTitleId,
    titleProps: {
      id: confirmModalTitleId
    },
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.rollbackAgents.title",
      defaultMessage: "Roll back {agentCount, plural, one {agent} other {agents}} to previous version",
      values: {
        agentCount
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 9
      }
    }),
    onCancel: onClose,
    onConfirm: onSubmit,
    cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.rollbackAgents.cancelButtonLabel",
      defaultMessage: "Cancel",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 9
      }
    }),
    confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.rollbackAgents.confirmButtonLabel",
      defaultMessage: "Roll back {agentCount, plural, one {agent} other {agents}}",
      values: {
        agentCount
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 9
      }
    }),
    confirmButtonDisabled: isSubmitting,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  }, isSingleAgent ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.rollbackAgents.singleAgentDescription",
    defaultMessage: "You are about to roll back the agent running on ''{hostName}'' to version {version}. This action cannot be undone.",
    values: {
      hostName: agents[0].local_metadata.host.hostname,
      version: (_agents$0$upgrade = agents[0].upgrade) === null || _agents$0$upgrade === void 0 ? void 0 : (_agents$0$upgrade$rol = _agents$0$upgrade.rollbacks) === null || _agents$0$upgrade$rol === void 0 ? void 0 : (_agents$0$upgrade$rol2 = _agents$0$upgrade$rol[0]) === null || _agents$0$upgrade$rol2 === void 0 ? void 0 : _agents$0$upgrade$rol2.version
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.rollbackAgents.multipleAgentsDescription",
    defaultMessage: "You are about to roll back agents to their previous version. This action can not be undone.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 11
    }
  })));
};
exports.AgentRollbackModal = AgentRollbackModal;