"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentLogs = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-utils-plugin/public");
var _constants = require("./constants");
var _agent_logs = require("./agent_logs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/agent_details_page/components/agent_logs/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AgentLogs = exports.AgentLogs = /*#__PURE__*/(0, _react.memo)(({
  agent,
  agentPolicy
}) => {
  const stateContainer = (0, _react.useMemo)(() => (0, _public.createStateContainer)({
    ..._constants.DEFAULT_LOGS_STATE,
    ...(0, _public.getStateFromKbnUrl)(_constants.STATE_STORAGE_KEY, window.location.href, {
      getFromHashQuery: false
    })
  }, {
    update: state => updatedState => ({
      ...state,
      ...updatedState
    })
  }), []);
  const AgentLogsConnected = (0, _react.useMemo)(() => _agent_logs.AgentLogsUrlStateHelper.connect(state => ({
    state: state || _constants.DEFAULT_LOGS_STATE
  }))(_agent_logs.AgentLogsUI), []);
  const [isSyncReady, setIsSyncReady] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    const stateStorage = (0, _public.createKbnUrlStateStorage)({
      useHashQuery: false,
      useHash: false
    });
    const {
      start,
      stop
    } = (0, _public.syncState)({
      storageKey: _constants.STATE_STORAGE_KEY,
      stateContainer: stateContainer,
      stateStorage
    });
    start();
    setIsSyncReady(true);
    return () => {
      stop();
      stateContainer.set(_constants.DEFAULT_LOGS_STATE);
    };
  }, [stateContainer]);
  return /*#__PURE__*/_react.default.createElement(_agent_logs.AgentLogsUrlStateHelper.Provider, {
    value: stateContainer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }, isSyncReady ? /*#__PURE__*/_react.default.createElement(AgentLogsConnected, {
    agent: agent,
    agentPolicy: agentPolicy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 24
    }
  }) : null);
});