"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfiguredSettings = ConfiguredSettings;
exports.settingComponentRegistry = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _zod = require("@kbn/zod");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _yaml_code_editor_with_placeholder = require("../../sections/settings/components/edit_output_flyout/yaml_code_editor_with_placeholder");
var _settings_field_group = require("./settings_field_group");
var _settings_field_wrapper = require("./settings_field_wrapper");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/components/form_settings/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const settingComponentRegistry = exports.settingComponentRegistry = new Map();
settingComponentRegistry.set(_zod.ZodFirstPartyTypeKind.ZodObject, ({
  disabled,
  ...settingsConfig
}) => /*#__PURE__*/_react.default.createElement(_settings_field_group.SettingsFieldGroup, {
  settingsConfig: settingsConfig,
  disabled: disabled,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 26,
    columnNumber: 3
  }
}));
settingComponentRegistry.set(_zod.ZodFirstPartyTypeKind.ZodNumber, ({
  disabled,
  ...settingsConfig
}) => {
  return /*#__PURE__*/_react.default.createElement(_settings_field_wrapper.SettingsFieldWrapper, {
    settingsConfig: settingsConfig,
    typeName: _zod.ZodFirstPartyTypeKind.ZodNumber,
    renderItem: ({
      fieldKey,
      fieldValue,
      handleChange,
      isInvalid,
      coercedSchema
    }) => {
      var _coercedSchema$minVal, _coercedSchema$maxVal;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
        fullWidth: true,
        disabled: disabled,
        "data-test-subj": fieldKey,
        value: fieldValue,
        onChange: handleChange,
        isInvalid: isInvalid,
        min: (_coercedSchema$minVal = coercedSchema.minValue) !== null && _coercedSchema$minVal !== void 0 ? _coercedSchema$minVal : undefined,
        max: (_coercedSchema$maxVal = coercedSchema.maxValue) !== null && _coercedSchema$maxVal !== void 0 ? _coercedSchema$maxVal : undefined,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 35,
          columnNumber: 9
        }
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  });
});
settingComponentRegistry.set(_zod.ZodFirstPartyTypeKind.ZodString, ({
  disabled,
  ...settingsConfig
}) => {
  if (settingsConfig.type === 'yaml') {
    return /*#__PURE__*/_react.default.createElement(_settings_field_wrapper.SettingsFieldWrapper, {
      settingsConfig: settingsConfig,
      typeName: _zod.ZodFirstPartyTypeKind.ZodString,
      renderItem: ({
        fieldKey,
        fieldValue,
        handleChange,
        isInvalid,
        coercedSchema
      }) => /*#__PURE__*/_react.default.createElement(_yaml_code_editor_with_placeholder.YamlCodeEditorWithPlaceholder, {
        value: fieldValue,
        onChange: value => handleChange({
          target: {
            value
          }
        }),
        disabled: disabled,
        placeholder: _i18n.i18n.translate('xpack.fleet.settings.agentPolicyAdvanced.yamlSettingsPlaceholder', {
          defaultMessage: '# Add YAML settings here'
        }),
        "data-test-subj": fieldKey,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 57,
          columnNumber: 11
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_settings_field_wrapper.SettingsFieldWrapper, {
    settingsConfig: settingsConfig,
    typeName: _zod.ZodFirstPartyTypeKind.ZodString,
    renderItem: ({
      fieldKey,
      fieldValue,
      handleChange,
      isInvalid
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      fullWidth: true,
      disabled: disabled,
      "data-test-subj": fieldKey,
      value: fieldValue,
      onChange: handleChange,
      isInvalid: isInvalid,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 9
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  });
});
settingComponentRegistry.set(_zod.ZodFirstPartyTypeKind.ZodEnum, ({
  disabled,
  ...settingsConfig
}) => {
  return /*#__PURE__*/_react.default.createElement(_settings_field_wrapper.SettingsFieldWrapper, {
    disabled: disabled,
    settingsConfig: settingsConfig,
    typeName: _zod.ZodFirstPartyTypeKind.ZodEnum,
    renderItem: ({
      fieldKey,
      fieldValue,
      handleChange
    }) => {
      var _settingsConfig$title;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
        "data-test-subj": fieldKey,
        value: fieldValue,
        fullWidth: true,
        disabled: disabled,
        onChange: handleChange,
        "aria-label": (_settingsConfig$title = settingsConfig.title) !== null && _settingsConfig$title !== void 0 ? _settingsConfig$title : _i18n.i18n.translate('xpack.fleet.configuredSettings.selectOptionsAriaLabel', {
          defaultMessage: 'Settings options'
        }),
        options: settingsConfig.options ? settingsConfig.options : settingsConfig.schema._def.innerType._def.values.map(value => ({
          text: value,
          value
        })),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 98,
          columnNumber: 9
        }
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 5
    }
  });
});
settingComponentRegistry.set(_zod.ZodFirstPartyTypeKind.ZodBoolean, ({
  disabled,
  ...settingsConfig
}) => {
  return /*#__PURE__*/_react.default.createElement(_settings_field_wrapper.SettingsFieldWrapper, {
    disabled: disabled,
    settingsConfig: settingsConfig,
    typeName: _zod.ZodFirstPartyTypeKind.ZodBoolean,
    renderItem: ({
      fieldKey,
      fieldValue,
      handleChange
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
      "data-test-subj": fieldKey,
      id: fieldKey,
      label: _i18n.i18n.translate('xpack.fleet.configuredSettings.genericCheckboxLabel', {
        defaultMessage: 'Enable'
      }),
      checked: fieldValue,
      onChange: handleChange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 7
    }
  });
});
function ConfiguredSettings({
  configuredSettings,
  disabled
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, configuredSettings.filter(configuredSetting => !configuredSetting.hidden).map(configuredSetting => {
    const Component = settingComponentRegistry.get((0, _settings_field_wrapper.getInnerType)(configuredSetting.schema));
    if (!Component) {
      throw new Error(`Unknown setting type: ${configuredSetting.schema._type}`);
    }
    return /*#__PURE__*/_react.default.createElement(Component, (0, _extends2.default)({
      key: configuredSetting.name
    }, configuredSetting, {
      disabled: disabled,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 13
      }
    }));
  }));
}