"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldsMetadataDictionary = void 0;
var _lodash = require("lodash");
var _create_proxied_fields_map = require("../utils/create_proxied_fields_map");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class FieldsMetadataDictionary {
  constructor(fields) {
    this.fields = fields;
  }
  getFields() {
    return this.fields;
  }
  pick(attributes) {
    return (0, _lodash.mapValues)(this.fields, field => field.pick(attributes));
  }
  toPlain() {
    return (0, _lodash.mapValues)(this.fields, field => field.toPlain());
  }
  static create(fields) {
    // Wrap fields in a proxy to handle prefixed field lookups dynamically
    const proxiedFields = (0, _create_proxied_fields_map.createProxiedFieldsMap)(fields);
    return new FieldsMetadataDictionary(proxiedFields);
  }
}
exports.FieldsMetadataDictionary = FieldsMetadataDictionary;