"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tagcloudRenderer = exports.strings = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactDom = require("react-dom");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _visualizationsCommon = require("@kbn/visualizations-common");
var _analytics = require("@kbn/analytics");
var _ebtTools = require("@kbn/ebt-tools");
var _chartExpressionsCommon = require("@kbn/chart-expressions-common");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _common = require("../../common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/chart_expressions/expression_tagcloud/public/expression_renderers/tagcloud_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const strings = exports.strings = {
  getDisplayName: () => _i18n.i18n.translate('expressionTagcloud.renderer.tagcloud.displayName', {
    defaultMessage: 'Tag Cloud visualization'
  }),
  getHelpDescription: () => _i18n.i18n.translate('expressionTagcloud.renderer.tagcloud.helpDescription', {
    defaultMessage: 'Render a tag cloud'
  })
};
const tagCloudVisClass = {
  height: '100%'
};
const TagCloudChart = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../components/tagcloud_component'))));
const tagcloudRenderer = ({
  getStartDeps
}) => ({
  name: _common.EXPRESSION_NAME,
  displayName: strings.getDisplayName(),
  help: strings.getHelpDescription(),
  reuseDomNode: true,
  render: async (domNode, config, handlers) => {
    const performanceTracker = (0, _ebtTools.createPerformanceTracker)({
      type: _ebtTools.PERFORMANCE_TRACKER_TYPES.PANEL,
      subType: _common.EXPRESSION_NAME
    });
    performanceTracker.mark(_ebtTools.PERFORMANCE_TRACKER_MARKS.PRE_RENDER);
    const {
      core,
      plugins
    } = getStartDeps();
    handlers.onDestroy(() => {
      (0, _reactDom.unmountComponentAtNode)(domNode);
    });
    const renderComplete = () => {
      performanceTracker.mark(_ebtTools.PERFORMANCE_TRACKER_MARKS.RENDER_COMPLETE);
      const executionContext = handlers.getExecutionContext();
      const containerType = (0, _chartExpressionsCommon.extractContainerType)(executionContext);
      const visualizationType = (0, _chartExpressionsCommon.extractVisualizationType)(executionContext);
      if (containerType && visualizationType) {
        var _plugins$usageCollect;
        (_plugins$usageCollect = plugins.usageCollection) === null || _plugins$usageCollect === void 0 ? void 0 : _plugins$usageCollect.reportUiCounter(containerType, _analytics.METRIC_TYPE.COUNT, [`render_${visualizationType}_${_common.EXPRESSION_NAME}`]);
      }
      handlers.done();
    };
    const chartSizeEvent = {
      name: 'chartSize',
      data: {
        maxDimensions: {
          x: {
            value: 100,
            unit: 'percentage'
          },
          y: {
            value: 100,
            unit: 'percentage'
          }
        }
      }
    };
    handlers.event(chartSizeEvent);
    const palettesRegistry = await plugins.charts.palettes.getPalettes();
    performanceTracker.mark(_ebtTools.PERFORMANCE_TRACKER_MARKS.RENDER_START);
    (0, _reactDom.render)(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, core, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 7
      }
    }), /*#__PURE__*/_react.default.createElement(_react2.ClassNames, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 9
      }
    }, ({
      css,
      cx
    }) => /*#__PURE__*/_react.default.createElement(_visualizationsCommon.VisualizationContainer, {
      handlers: handlers
      // Class `tagCloudContainer` is generated by `@emotion/react` and passed as a defined class to `VisualizationContainer`.
      // It is used for rendering at `Canvas`.
      ,
      className: cx('tagCloudContainer', css(tagCloudVisClass)),
      renderComplete: renderComplete,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(TagCloudChart, (0, _extends2.default)({}, config, {
      palettesRegistry: palettesRegistry,
      renderComplete: renderComplete,
      fireEvent: handlers.event,
      syncColors: config.syncColors,
      overrides: config.overrides,
      isDarkMode: (0, _reactKibanaContextTheme.useKibanaIsDarkMode)(),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 15
      }
    }))))), domNode);
  }
});
exports.tagcloudRenderer = tagcloudRenderer;