"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatePickerCol = DatePickerCol;
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_series_storage = require("../../hooks/use_series_storage");
var _date_range_picker = require("../../components/date_range_picker");
var _series_date_picker = require("../../components/series_date_picker");
var _constants = require("../../configurations/constants");
var _use_app_data_view = require("../../hooks/use_app_data_view");
var _synthetics_add_data = require("../../../add_data_buttons/synthetics_add_data");
var _mobile_add_data = require("../../../add_data_buttons/mobile_add_data");
var _ux_add_data = require("../../../add_data_buttons/ux_add_data");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/exploratory_view/public/components/shared/exploratory_view/series_editor/columns/date_picker_col.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AddDataComponents = {
  mobile: _mobile_add_data.MobileAddData,
  ux: _ux_add_data.UXAddData,
  uptime: _synthetics_add_data.SyntheticsAddData,
  synthetics: null,
  apm: null,
  infra_logs: null,
  infra_metrics: null,
  alerts: null
};
function DatePickerCol({
  seriesId,
  series
}) {
  const {
    reportType
  } = (0, _use_series_storage.useSeriesStorage)();
  const {
    hasAppData
  } = (0, _use_app_data_view.useAppDataViewContext)();
  if (!series.dataType) {
    return null;
  }
  const AddDataButton = AddDataComponents[series.dataType];
  if (hasAppData[series.dataType] === false && AddDataButton !== null) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("strong", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.exploratoryView.noDataAvailable', {
      defaultMessage: 'No {dataType} data available.',
      values: {
        dataType: series.dataType
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(AddDataButton, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 11
      }
    })));
  }
  return /*#__PURE__*/_react.default.createElement(Wrapper, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 5
    }
  }, seriesId === 0 || reportType !== _constants.ReportTypes.KPI ? /*#__PURE__*/_react.default.createElement(_series_date_picker.SeriesDatePicker, {
    seriesId: seriesId,
    series: series,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_date_range_picker.DateRangePicker, {
    seriesId: seriesId,
    series: series,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  }));
}
const Wrapper = _styled.default.div`
  width: 100%;
`;