"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.untilPluginStartServicesReady = exports.setKibanaServices = exports.core = void 0;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

let core = exports.core = void 0;
const servicesReady$ = new _rxjs.BehaviorSubject(undefined);
const untilPluginStartServicesReady = () => {
  if (servicesReady$.value) return Promise.resolve(servicesReady$.value);
  return new Promise(resolve => {
    const subscription = servicesReady$.subscribe(deps => {
      if (deps) {
        subscription.unsubscribe();
        resolve(deps);
      }
    });
  });
};
exports.untilPluginStartServicesReady = untilPluginStartServicesReady;
const setKibanaServices = (esql, kibanaCore, data, storage, uiActions, fieldsMetadata, usageCollection) => {
  exports.core = core = kibanaCore;
  servicesReady$.next({
    core,
    data,
    storage,
    uiActions,
    fieldsMetadata,
    usageCollection,
    docLinks: core.docLinks,
    esql
  });
};
exports.setKibanaServices = setKibanaServices;