"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getJoinIndices = void 0;
var _cache = require("./utils/cache");
var _query_parsing_helpers = require("../query_parsing_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getLookupIndices = (0, _cache.cacheParametrizedAsyncFunction)(async (http, remoteClusters) => {
  const query = remoteClusters ? {
    remoteClusters
  } : {};
  const result = await http.get('/internal/esql/autocomplete/join/indices', {
    query
  });
  return result;
}, (http, remoteClusters) => remoteClusters || '', 1000 * 60 * 5,
// Keep the value in cache for 5 minutes
1000 * 15 // Refresh the cache in the background only if 15 seconds passed since the last call
);

/**
 * Fetches join indices based on the provided ESQL query.
 * @param query The ESQL query string to extract remote clusters from.
 * @param http The HTTP service to use for the request.
 * @param cacheOptions Optional cache options to control cache behavior.
 * @returns A promise that resolves to an IndicesAutocompleteResult object.
 */
const getJoinIndices = async (query, http, cacheOptions) => {
  const remoteClusters = (0, _query_parsing_helpers.getRemoteClustersFromESQLQuery)(query);
  const result = await getLookupIndices.call({
    forceRefresh: cacheOptions === null || cacheOptions === void 0 ? void 0 : cacheOptions.forceRefresh
  }, http, remoteClusters === null || remoteClusters === void 0 ? void 0 : remoteClusters.join(','));
  return result;
};
exports.getJoinIndices = getJoinIndices;