"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.appendStatsByToQuery = void 0;
var _esqlAst = require("@kbn/esql-ast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const appendStatsByToQuery = (queryString, column) => {
  const {
    root
  } = _esqlAst.Parser.parse(queryString);
  const lastCommand = root.commands[root.commands.length - 1];
  if (lastCommand.name === 'stats') {
    const statsCommand = lastCommand;
    _esqlAst.mutate.generic.commands.remove(root, statsCommand);
    const queryWithoutStats = _esqlAst.BasicPrettyPrinter.print(root);
    return `${queryWithoutStats}\n| STATS BY ${column}`;
  } else {
    return `${queryString}\n| STATS BY ${column}`;
  }
};
exports.appendStatsByToQuery = appendStatsByToQuery;