"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.replaceParameters = replaceParameters;
var _esqlAst = require("@kbn/esql-ast");
var _parameter_replacer = require("../transformers/parameter_replacer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function replaceParameters(queryAst, params) {
  const parameterReplacer = new _parameter_replacer.ParameterReplacer(params);
  _esqlAst.Walker.walk(queryAst, {
    visitLiteral: (node, parent) => {
      if (parameterReplacer.shouldReplaceNode(node)) {
        replaceInPlace(node, parameterReplacer.replace(node, parent));
      }
    },
    visitColumn: (node, parent) => {
      if (parameterReplacer.shouldReplaceNode(node)) {
        replaceInPlace(node, parameterReplacer.replace(node, parent));
      }
    },
    visitFunction: node => {
      if (parameterReplacer.shouldReplaceNode(node)) {
        replaceInPlace(node, parameterReplacer.replace(node));
      }
    }
  });
}
function replaceInPlace(target, replacement) {
  Object.keys(target).forEach(key => {
    if (!Object.prototype.hasOwnProperty.call(replacement, key)) {
      delete target[key];
    }
  });
  Object.assign(target, replacement);
}