"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createPipeline = createPipeline;
var _esqlAst = require("@kbn/esql-ast");
var _build_query_ast = require("./build_query_ast");
var _replace_parameters = require("./replace_parameters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function createPipeline(source) {
  const toString = () => {
    const ast = (0, _build_query_ast.buildQueryAst)(source);
    (0, _replace_parameters.replaceParameters)(ast, source.params);
    return _esqlAst.BasicPrettyPrinter.print(ast, {
      multiline: true
    });
  };
  const asRequest = () => {
    const ast = (0, _build_query_ast.buildQueryAst)(source);
    return {
      query: _esqlAst.BasicPrettyPrinter.print(ast, {
        multiline: true
      }),
      params: source.params
    };
  };
  const pipe = (...operators) => {
    const nextSource = operators.reduce((q, op) => op(q), source);
    return createPipeline(nextSource);
  };
  return {
    pipe,
    toString,
    asRequest
  };
}