"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.quotableKeywords = void 0;
var _esql_lexer = _interopRequireDefault(require("../parser/antlr/esql_lexer"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

let _quotableKeywords;

/**
 * Lazily retrieves a set of keywords that should be quoted in ESQL.
 *
 * @returns Set of keywords that should be quoted in ESQL.
 */
const quotableKeywords = () => {
  if (_quotableKeywords) {
    return _quotableKeywords;
  }
  _quotableKeywords = new Set();
  for (const literalName of _esql_lexer.default.literalNames) {
    // Remove null and empty strings
    if (typeof literalName !== 'string') {
      continue;
    }
    const lastChar = literalName.length - 1;

    // ANTLR wraps literals with single quotes, so we check for that.
    if (literalName[0] !== "'" || literalName[lastChar] !== "'") {
      continue;
    }
    const keyword = literalName.slice(1, lastChar);

    // Only add non-empty keywords that consist of alphanumeric characters or
    // underscores. This prevents adding symbols like `::`, `,`, etc.
    if (/^\w+$/.test(keyword)) {
      _quotableKeywords.add(keyword.toUpperCase());
    }
  }
  return _quotableKeywords;
};
exports.quotableKeywords = quotableKeywords;