"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasLineBreakingDecoration = exports.getPrettyPrintStats = void 0;
var _walker = require("../ast/walker");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Walks once the given AST sub-tree and computes the pretty print stats.
 *
 * @param ast The part to compute the stats for.
 */
const getPrettyPrintStats = ast => {
  const stats = {
    hasLineBreakingDecorations: false,
    hasRightSingleLineComments: false
  };
  _walker.Walker.walk(ast, {
    visitAny: node => {
      var _node$formatting;
      if (hasLineBreakingDecoration(node)) {
        stats.hasLineBreakingDecorations = true;
      }
      if (!!((_node$formatting = node.formatting) !== null && _node$formatting !== void 0 && _node$formatting.rightSingleLine)) {
        stats.hasRightSingleLineComments = true;
      }
    }
  });
  return stats;
};
exports.getPrettyPrintStats = getPrettyPrintStats;
const hasLineBreakingDecoration = node => {
  const formatting = node.formatting;
  if (!formatting) {
    return false;
  }
  if (!!formatting.top && formatting.top.length > 0 || !!formatting.bottom && formatting.bottom.length > 0 || !!formatting.rightSingleLine) {
    return true;
  }
  for (const decoration of [...((_formatting$left = formatting.left) !== null && _formatting$left !== void 0 ? _formatting$left : []), ...((_formatting$right = formatting.right) !== null && _formatting$right !== void 0 ? _formatting$right : [])]) {
    var _formatting$left, _formatting$right;
    if (decoration.type === 'comment' && decoration.subtype === 'multi-line' && !decoration.text.includes('\n')) {
      continue;
    }
    return true;
  }
  return false;
};
exports.hasLineBreakingDecoration = hasLineBreakingDecoration;