"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFunctionSignatureHover = getFunctionSignatureHover;
var _utils = require("../../commands/definitions/utils");
var _hover_cache = require("./hover_cache");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function getFunctionSignatureHover(fnNode, getColumnMap) {
  // Use function name and argument types as cache key, fnName:argType1,argType2
  const cacheKey = fnNode.name;
  const cached = (0, _hover_cache.fromCache)(cacheKey);
  if (cached) {
    return cached;
  }
  const fnDefinition = (0, _utils.getFunctionDefinition)(fnNode.name);
  if (fnDefinition) {
    const formattedSignature = (0, _utils.getFormattedFunctionSignature)(fnDefinition, fnNode);
    const result = [{
      value: `\`\`\`none
${formattedSignature}
\`\`\``
    }, {
      value: fnDefinition.description
    }];
    (0, _hover_cache.setToCache)(cacheKey, result);
    return result;
  } else {
    (0, _hover_cache.setToCache)(cacheKey, []);
    return [];
  }
}