"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.autocomplete = autocomplete;
var _complete_items = require("../complete_items");
var _utils = require("../../definitions/utils");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function autocomplete(query, command, callbacks, context, cursorPosition = query.length) {
  if (!(callbacks !== null && callbacks !== void 0 && callbacks.getByType)) {
    return [];
  }
  const expressionRoot = command.args[0];
  const {
    suggestions,
    computed
  } = await (0, _utils.suggestForExpression)({
    query,
    expressionRoot,
    command,
    cursorPosition,
    location: _types.Location.WHERE,
    context,
    callbacks,
    options: {
      preferredExpressionType: 'boolean'
    }
  });
  const {
    expressionType,
    isComplete,
    insideFunction
  } = computed;
  if (expressionType === 'boolean' && isComplete && !insideFunction) {
    suggestions.push(_complete_items.pipeCompleteItem);
  }
  return suggestions;
}