"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validate = void 0;
var _expressions = require("../../definitions/utils/expressions");
var _validation = require("../../definitions/utils/validation");
var _errors = require("../../definitions/utils/errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const supportedQueryTypes = ['keyword', 'text', 'param'];
const validate = (command, ast, context, callbacks) => {
  const messages = [];
  const {
    query,
    location,
    inferenceId
  } = command;
  const rerankExpressionType = (0, _expressions.getExpressionType)(query, context === null || context === void 0 ? void 0 : context.columns);

  // check for supported query types
  if (!supportedQueryTypes.includes(rerankExpressionType)) {
    messages.push(_errors.errors.byId('unsupportedQueryType', 'location' in query ? query === null || query === void 0 ? void 0 : query.location : location, {
      command: 'RERANK',
      expressionType: rerankExpressionType
    }));
  }
  if (inferenceId !== null && inferenceId !== void 0 && inferenceId.incomplete) {
    messages.push(_errors.errors.byId('inferenceIdRequired', command.location, {
      command: 'RERANK'
    }));
  }
  messages.push(...(0, _validation.validateCommandArguments)(command, ast, context, callbacks));
  return messages;
};
exports.validate = validate;