"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.autocomplete = autocomplete;
var _complete_items = require("../complete_items");
var _helpers = require("../../definitions/utils/autocomplete/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function autocomplete(query, command, callbacks, context, cursorPosition) {
  var _await$callbacks$getB, _callbacks$getByType;
  const innerText = query.substring(0, cursorPosition);
  if (/(?:rename|,)\s+\S+\s+a$/i.test(innerText)) {
    return [_complete_items.asCompletionItem];
  }

  // If the left side of the rename is a column that exists, we suggest the 'AS' completion item.
  // If it doesn't exist, we suggest the '=' completion item.
  const match = innerText.match(/(?:rename|,)\s+(\S+)\s+a?$/i);
  if (match) {
    const leftSideOfRename = match[1];
    return (0, _helpers.columnExists)(leftSideOfRename, context) ? [_complete_items.asCompletionItem] : [_complete_items.assignCompletionItem];
  }
  if (/(?:rename|,)\s+\S+\s+a?$/i.test(innerText)) {
    return [_complete_items.asCompletionItem, _complete_items.assignCompletionItem];
  }
  if (/rename(?:\s+\S+\s+(as|=)\s+\S+\s*,)*\s+\S+\s+(as|=)\s+[^\s,]+\s+$/i.test(innerText)) {
    return [_complete_items.pipeCompleteItem, {
      ..._complete_items.commaCompleteItem,
      text: ', '
    }];
  }
  if (/as\s+$/i.test(innerText)) {
    return [];
  }
  const suggestions = (_await$callbacks$getB = await (callbacks === null || callbacks === void 0 ? void 0 : (_callbacks$getByType = callbacks.getByType) === null || _callbacks$getByType === void 0 ? void 0 : _callbacks$getByType.call(callbacks, 'any', [], {
    advanceCursor: true,
    openSuggestions: true
  }))) !== null && _await$callbacks$getB !== void 0 ? _await$callbacks$getB : [];
  if (!/=\s+$/i.test(innerText)) {
    var _callbacks$getSuggest;
    suggestions.push((0, _complete_items.getNewUserDefinedColumnSuggestion)((callbacks === null || callbacks === void 0 ? void 0 : (_callbacks$getSuggest = callbacks.getSuggestedUserDefinedColumnName) === null || _callbacks$getSuggest === void 0 ? void 0 : _callbacks$getSuggest.call(callbacks)) || ''));
  }
  return suggestions;
}