"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.boolean = boolean;
exports.date = date;
exports.dateNanos = dateNanos;
exports.flattened = flattened;
exports.integer = integer;
exports.keyword = keyword;
exports.long = long;
exports.object = object;
exports.short = short;
exports.text = text;
var _lodash = require("lodash");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function object(def) {
  const defaults = (0, _utils.omitUnsetKeys)({
    type: 'object'
  }, def);
  return (0, _lodash.merge)(defaults, def);
}
function text(def) {
  const defaults = (0, _utils.omitUnsetKeys)({
    type: 'text',
    fields: {
      keyword: {
        type: 'keyword',
        ignore_above: 1024
      }
    }
  }, def);
  return (0, _lodash.merge)(defaults, def);
}
function keyword(def) {
  const defaults = (0, _utils.omitUnsetKeys)({
    type: 'keyword',
    ignore_above: 1024
  }, def);
  return (0, _lodash.merge)(defaults, def);
}
function date(def) {
  const defaults = (0, _utils.omitUnsetKeys)({
    type: 'date'
  }, def);
  return (0, _lodash.merge)(defaults, def);
}
function dateNanos(def) {
  const defaults = (0, _utils.omitUnsetKeys)({
    type: 'date_nanos'
  }, def);
  return (0, _lodash.merge)(defaults, def);
}
function integer(def) {
  const defaults = (0, _utils.omitUnsetKeys)({
    type: 'integer'
  }, def);
  return (0, _lodash.merge)(defaults, def);
}
function long(def) {
  const defaults = (0, _utils.omitUnsetKeys)({
    type: 'long'
  }, def);
  return (0, _lodash.merge)(defaults, def);
}
function short(def) {
  const defaults = (0, _utils.omitUnsetKeys)({
    type: 'short'
  }, def);
  return (0, _lodash.merge)(defaults, def);
}
function boolean(def) {
  const defaults = (0, _utils.omitUnsetKeys)({
    type: 'boolean'
  }, def);
  return (0, _lodash.merge)(defaults, def);
}
function flattened(def) {
  const defaults = (0, _utils.omitUnsetKeys)({
    type: 'flattened'
  }, def);
  return (0, _lodash.merge)(defaults, def);
}