"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.testExcludeNoIntersection = exports.testExcludeLHSMoreKeys = exports.testExclude2 = exports.testExactSubsetRHS = exports.testExactSubsetLHS = exports.testExactSchema = exports.testExactDifferentValueTypes = exports.testExactDifferentKeys = exports.testExact = exports.singleKeyError = exports.multipleKeysError = exports.invalidKeysError = exports.excludedKeys = exports.b = exports.a = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// Suite MissingKeysError Helper Type
// Test: MissingKeysError for a single key

const singleKeyError = exports.singleKeyError = Object.assign(new Error(), 'The following keys are missing from the document fields: isActive');
const excludedKeys = exports.excludedKeys = ['exclusiveFirstOne', 'exclusiveFirstTwo'];

// Test: MissingKeysError for multiple keys

const multipleKeysError = exports.multipleKeysError = [Object.assign(new Error(), 'The following keys are missing from the document fields: exclusiveFirstOne'), Object.assign(new Error(), 'The following keys are missing from the document fields: exclusiveFirstTwo')];

// Makes sure that we can't pass in a key that is not in the excludedKeys
const invalidKeysError = exports.invalidKeysError = [Object.assign(new Error(), 'The following keys are missing from the document fields: exclusiveFirstOne'), Object.assign(new Error(), 'The following keys are missing from the document fields: exclusiveFirstTwo'),
// @ts-expect-error - exclusiveFirstThree is not in the excludedKeys
Object.assign(new Error(), 'The following keys are missing from the document fields: exclusiveFirstThree')];

// Suite Exact Helper Type
// Test: Exact with LHS = RHS

const testExact = exports.testExact = true;
const testExactSchema = exports.testExactSchema = true;

// Test: Exact with LHS subset of RHS

const testExactSubsetLHS = exports.testExactSubsetLHS = false;

// Test: Exact with RHS subset of LHS

const testExactSubsetRHS = exports.testExactSubsetRHS = false;

// Test: Exact with LHS and RHS having different keys

const testExactDifferentKeys = exports.testExactDifferentKeys = false;

// Test: Exact with LHS and RHS having different value types

const testExactDifferentValueTypes = exports.testExactDifferentValueTypes = false;

// Suite Exclude Utility Type
// Test: Exclude LHS has more keys than RHS

const testExcludeLHSMoreKeys = exports.testExcludeLHSMoreKeys = 'B';

// Test: Exclude LHS has no intersection with RHS

const testExcludeNoIntersection = exports.testExcludeNoIntersection = 'A';

// Test: Exclude RHS has more keys than LHS (never)

let testExclude2 = exports.testExclude2 = void 0;

// Suite PartialWithArrayValues Helper Type
// Test allows casting to arrays of field

// Test allows casting to arrays of nested fields

// Test allows casting to arrays of nested fields with optional values

// Test allows casting to arrays of nested fields
const a = exports.a = [{
  b: 'test'
}];

// Test allows casting to objects with nested fields with optional values
const b = exports.b = {
  a: {
    // @ts-expect-error - a is casted to an array of objects, not an object
    b: 'test',
    c: 1
  }
};