"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.semVerSchema = exports.percentileMetricSchema = exports.metricSchema = exports.metadataSchema = exports.metadataAggregation = exports.keyMetricSchema = exports.identityFieldsSchema = exports.historySettingsSchema = exports.filterSchema = exports.durationSchemaWithMinimum = exports.durationSchema = exports.docCountMetricSchema = exports.capabilitySchema = exports.basicMetricWithFieldSchema = exports.basicAggregationsSchema = exports.arrayOfStringsSchema = exports.EntityStoreCapability = exports.BasicAggregations = void 0;
var _zod = require("@kbn/zod");
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const arrayOfStringsSchema = exports.arrayOfStringsSchema = _zod.z.array(_zod.z.string());
let BasicAggregations = exports.BasicAggregations = /*#__PURE__*/function (BasicAggregations) {
  BasicAggregations["avg"] = "avg";
  BasicAggregations["max"] = "max";
  BasicAggregations["min"] = "min";
  BasicAggregations["sum"] = "sum";
  BasicAggregations["value_count"] = "value_count";
  BasicAggregations["cardinality"] = "cardinality";
  BasicAggregations["last_value"] = "last_value";
  BasicAggregations["std_deviation"] = "std_deviation";
  return BasicAggregations;
}({});
const basicAggregationsSchema = exports.basicAggregationsSchema = _zod.z.nativeEnum(BasicAggregations);
const metricNameSchema = _zod.z.string().length(1).regex(/[a-zA-Z]/).toUpperCase();
const filterSchema = exports.filterSchema = _zod.z.optional(_zod.z.string());
const basicMetricWithFieldSchema = exports.basicMetricWithFieldSchema = _zod.z.object({
  name: metricNameSchema,
  aggregation: basicAggregationsSchema,
  field: _zod.z.string(),
  filter: filterSchema
});
const docCountMetricSchema = exports.docCountMetricSchema = _zod.z.object({
  name: metricNameSchema,
  aggregation: _zod.z.literal('doc_count'),
  filter: filterSchema
});
const durationSchema = exports.durationSchema = _zod.z.string().regex(/^\d+[m|s|d|h]$/, {
  message: 'Must be a number followed by one of the units: m, s, d or h'
});
const durationSchemaWithMinimum = minimumMinutes => durationSchema.refine(val => {
  const parts = val.match(/(\d+)([m|s|h|d])/);
  if (parts === null) {
    throw new Error('Unable to parse duration');
  }
  const value = parseInt(parts[1], 10);
  const unit = parts[2];
  return _moment.default.duration(value, unit).asMinutes() >= minimumMinutes;
}, {
  message: `can not be less than ${minimumMinutes}m`
});
exports.durationSchemaWithMinimum = durationSchemaWithMinimum;
const percentileMetricSchema = exports.percentileMetricSchema = _zod.z.object({
  name: metricNameSchema,
  aggregation: _zod.z.literal('percentile'),
  field: _zod.z.string(),
  percentile: _zod.z.number(),
  filter: filterSchema
});
const metricSchema = exports.metricSchema = _zod.z.discriminatedUnion('aggregation', [basicMetricWithFieldSchema, docCountMetricSchema, percentileMetricSchema]);
const keyMetricSchema = exports.keyMetricSchema = _zod.z.object({
  name: _zod.z.string(),
  metrics: _zod.z.array(metricSchema),
  equation: _zod.z.string()
});
const metadataAggregation = exports.metadataAggregation = _zod.z.union([_zod.z.object({
  type: _zod.z.literal('terms'),
  limit: _zod.z.number().default(10),
  lookbackPeriod: _zod.z.optional(durationSchema)
}), _zod.z.object({
  type: _zod.z.literal('top_value'),
  sort: _zod.z.record(_zod.z.string(), _zod.z.union([_zod.z.literal('asc'), _zod.z.literal('desc')])),
  lookbackPeriod: _zod.z.optional(durationSchema)
})]);
const metadataSchema = exports.metadataSchema = _zod.z.object({
  source: _zod.z.string(),
  destination: _zod.z.optional(_zod.z.string()),
  aggregation: _zod.z.optional(metadataAggregation).default({
    type: _zod.z.literal('terms').value,
    limit: 10,
    lookbackPeriod: undefined
  })
}).or(_zod.z.string().transform(value => ({
  source: value,
  destination: value,
  aggregation: {
    type: _zod.z.literal('terms').value,
    limit: 10,
    lookbackPeriod: undefined
  }
}))).transform(metadata => {
  var _metadata$destination;
  return {
    ...metadata,
    destination: (_metadata$destination = metadata.destination) !== null && _metadata$destination !== void 0 ? _metadata$destination : metadata.source
  };
}).superRefine((value, ctx) => {
  if (value.aggregation.type === 'terms' && value.aggregation.limit < 1) {
    ctx.addIssue({
      path: ['limit'],
      code: _zod.z.ZodIssueCode.custom,
      message: 'limit for terms aggregation should be greater than 1'
    });
  }
  if (value.source.length === 0) {
    ctx.addIssue({
      path: ['source'],
      code: _zod.z.ZodIssueCode.custom,
      message: 'source should not be empty'
    });
  }
  if (value.destination.length === 0) {
    ctx.addIssue({
      path: ['destination'],
      code: _zod.z.ZodIssueCode.custom,
      message: 'destination should not be empty'
    });
  }
});
const identityFieldsSchema = exports.identityFieldsSchema = _zod.z.object({
  field: _zod.z.string(),
  optional: _zod.z.literal(false)
}).or(_zod.z.string().transform(value => ({
  field: value,
  optional: false
})));
const semVerRegex = new RegExp(/^[0-9]{1,}\.[0-9]{1,}\.[0-9]{1,}$/);
const semVerSchema = exports.semVerSchema = _zod.z.string().refine(maybeSemVer => semVerRegex.test(maybeSemVer), {
  message: 'The string does use the Semantic Versioning (Semver) format of {major}.{minor}.{patch} (e.g., 1.0.0), ensure each part contains only digits.'
});
const historySettingsSchema = exports.historySettingsSchema = _zod.z.optional(_zod.z.object({
  syncField: _zod.z.optional(_zod.z.string()),
  syncDelay: _zod.z.optional(durationSchema),
  lookbackPeriod: _zod.z.optional(durationSchema).default('1h'),
  frequency: _zod.z.optional(durationSchema),
  backfillSyncDelay: _zod.z.optional(durationSchema),
  backfillLookbackPeriod: _zod.z.optional(durationSchema),
  backfillFrequency: _zod.z.optional(durationSchema)
})).transform(settings => {
  return {
    ...settings,
    lookbackPeriod: (settings === null || settings === void 0 ? void 0 : settings.lookbackPeriod) || durationSchema.parse('1h')
  };
});
let EntityStoreCapability = exports.EntityStoreCapability = /*#__PURE__*/function (EntityStoreCapability) {
  EntityStoreCapability["HISTORICAL_VIEWS"] = "HISTORICAL_VIEWS";
  EntityStoreCapability["CRUD_API"] = "CRUD_API";
  return EntityStoreCapability;
}({});
const capabilitySchema = exports.capabilitySchema = _zod.z.nativeEnum(EntityStoreCapability);