"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLegacyURLTransform = getLegacyURLTransform;
exports.hasLegacyURLTransform = hasLegacyURLTransform;
exports.registerLegacyURLTransform = registerLegacyURLTransform;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const registry = {};
function registerLegacyURLTransform(type, getTransformOut) {
  if (registry[type]) {
    throw new Error(`Embeddable legacy URL transform for type "${type}" is already registered.`);
  }
  registry[type] = getTransformOut;
}
async function getLegacyURLTransform(type) {
  var _registry$type;
  return await ((_registry$type = registry[type]) === null || _registry$type === void 0 ? void 0 : _registry$type.call(registry));
}
function hasLegacyURLTransform(type) {
  return Boolean(registry[type]);
}