"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertsTableEmbeddableFactory = void 0;
var _react = _interopRequireDefault(require("react"));
var _rxjs = require("rxjs");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _reactQuery = require("@kbn/react-query");
var _public = require("@kbn/kibana-react-plugin/public");
var _presentationContainers = require("@kbn/presentation-containers");
var _presentationUtil = require("@kbn/presentation-util");
var _solutions = require("@kbn/response-ops-alerts-filters-form/utils/solutions");
var _get_internal_rule_types_with_cache = require("../utils/get_internal_rule_types_with_cache");
var _translations = require("../translations");
var _constants = require("../constants");
var _embeddable_alerts_table = require("../components/embeddable_alerts_table");
var _query_client = require("../query_client");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/embeddable_alerts_table/public/factories/alerts_table_embeddable_factory.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getAlertsTableEmbeddableFactory = (coreServices, deps) => ({
  type: _constants.EMBEDDABLE_ALERTS_TABLE_ID,
  buildEmbeddable: async ({
    initialState,
    finalizeApi,
    parentApi,
    uuid
  }) => {
    var _initialState$rawStat;
    const timeRangeManager = (0, _presentationPublishing.initializeTimeRangeManager)(initialState === null || initialState === void 0 ? void 0 : initialState.rawState);
    const titleManager = (0, _presentationPublishing.initializeTitleManager)((_initialState$rawStat = initialState === null || initialState === void 0 ? void 0 : initialState.rawState) !== null && _initialState$rawStat !== void 0 ? _initialState$rawStat : {});
    const queryLoading$ = new _rxjs.BehaviorSubject(true);
    const services = {
      ...coreServices,
      ...deps
    };
    const initialTableConfig = initialState.rawState.tableConfig;
    const tableConfig$ = new _rxjs.BehaviorSubject(initialTableConfig);
    const serializeState = () => ({
      rawState: {
        ...titleManager.getLatestState(),
        ...timeRangeManager.getLatestState(),
        tableConfig: tableConfig$.getValue()
      }
    });
    const unsavedChangesApi = (0, _presentationContainers.initializeUnsavedChanges)({
      uuid,
      parentApi,
      anyStateChange$: (0, _rxjs.merge)(timeRangeManager.anyStateChange$, titleManager.anyStateChange$, tableConfig$).pipe((0, _rxjs.map)(() => undefined)),
      serializeState,
      getComparators: () => ({
        ..._presentationPublishing.titleComparators,
        ..._presentationPublishing.timeRangeComparators,
        tableConfig: 'deepEquality'
      }),
      onReset: lastSaved => {
        titleManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
        timeRangeManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
      }
    });
    const ruleTypes = await (0, _get_internal_rule_types_with_cache.getInternalRuleTypesWithCache)(coreServices.http);
    const ruleTypeIdsForSolution = !ruleTypes || !(initialTableConfig !== null && initialTableConfig !== void 0 && initialTableConfig.solution) ? [] : (0, _solutions.getRuleTypeIdsForSolution)(ruleTypes, initialTableConfig.solution);
    const api = finalizeApi({
      ...timeRangeManager.api,
      ...titleManager.api,
      ...unsavedChangesApi,
      dataLoading$: queryLoading$,
      serializeState,
      isEditingEnabled: () => {
        // Users cannot edit panels based on a solution they cannot access.
        // The first condition ensures panels are editable even if the table configuration is
        // unexpectedly undefined or incomplete
        return !(initialTableConfig !== null && initialTableConfig !== void 0 && initialTableConfig.solution) || ruleTypeIdsForSolution.length > 0;
      },
      getTypeDisplayName: () => _translations.ALERTS_PANEL_LABEL,
      onEdit: async () => {
        try {
          (0, _presentationUtil.openLazyFlyout)({
            core: coreServices,
            parentApi: api.parentApi,
            loadContent: async ({
              closeFlyout,
              ariaLabelledBy
            }) => {
              const {
                ConfigEditor
              } = await Promise.resolve().then(() => _interopRequireWildcard(require('../components/config_editor')));
              return /*#__PURE__*/_react.default.createElement(ConfigEditor, {
                initialConfig: tableConfig$.getValue(),
                ariaLabelledBy: ariaLabelledBy,
                coreServices: coreServices,
                closeFlyout: closeFlyout,
                onSave: newConfig => {
                  tableConfig$.next(newConfig);
                },
                __self: void 0,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 109,
                  columnNumber: 17
                }
              });
            }
          });
        } catch {
          // The user closed without saving, discard the edits
        }
      }
    });
    return {
      api,
      Component: () => {
        const {
          timeRange: selectedTimeRange
        } = (0, _presentationPublishing.useFetchContext)(api);
        const tableConfig = (0, _presentationPublishing.useStateFromPublishingSubject)(tableConfig$);
        return /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
          services: services,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 134,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
          client: _query_client.queryClient,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 135,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_embeddable_alerts_table.EmbeddableAlertsTable, {
          id: `${_constants.PERSISTED_TABLE_CONFIG_KEY_PREFIX}-${uuid}`,
          timeRange: selectedTimeRange,
          solution: tableConfig === null || tableConfig === void 0 ? void 0 : tableConfig.solution,
          query: tableConfig === null || tableConfig === void 0 ? void 0 : tableConfig.query,
          services: services,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 136,
            columnNumber: 15
          }
        })));
      }
    };
  }
});
exports.getAlertsTableEmbeddableFactory = getAlertsTableEmbeddableFactory;