"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteAllConversationsRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _common = require("@kbn/elastic-assistant-common/impl/schemas/common");
var _utils = require("../utils");
var _helpers = require("../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteAllConversationsRoute = router => {
  router.versioned.delete({
    access: 'public',
    path: _elasticAssistantCommon.ELASTIC_AI_ASSISTANT_CONVERSATIONS_URL,
    security: {
      authz: {
        requiredPrivileges: ['elasticAssistant']
      }
    }
  }).addVersion({
    version: _elasticAssistantCommon.API_VERSIONS.public.v1,
    validate: {
      request: {
        body: (0, _common.buildRouteValidationWithZod)(_elasticAssistantCommon.DeleteAllConversationsRequestBody)
      }
    }
  }, async (context, request, response) => {
    const assistantResponse = (0, _utils.buildResponse)(response);
    try {
      var _request$body, _result$failures;
      const ctx = await context.resolve(['core', 'elasticAssistant', 'licensing']);
      const checkResponse = await (0, _helpers.performChecks)({
        context: ctx,
        request,
        response
      });
      if (!checkResponse.isSuccess) {
        return checkResponse.response;
      }
      const dataClient = await ctx.elasticAssistant.getAIAssistantConversationsDataClient();
      const result = await (dataClient === null || dataClient === void 0 ? void 0 : dataClient.deleteAllConversations({
        excludedIds: (_request$body = request.body) === null || _request$body === void 0 ? void 0 : _request$body.excludedIds
      }));
      const hasFailures = (result === null || result === void 0 ? void 0 : result.failures) && result.failures.length > 0;
      return response.ok({
        body: {
          success: !hasFailures,
          totalDeleted: result === null || result === void 0 ? void 0 : result.total,
          failures: hasFailures ? (_result$failures = result.failures) === null || _result$failures === void 0 ? void 0 : _result$failures.map(failure => failure.cause.reason) : null
        }
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return assistantResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.deleteAllConversationsRoute = deleteAllConversationsRoute;