"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleGraphError = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _telemetry = require("../../../../helpers/telemetry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const handleGraphError = async ({
  apiConfig,
  err,
  logger,
  telemetry
}) => {
  try {
    logger.error(err);
    const error = (0, _securitysolutionEsUtils.transformError)(err);
    (0, _telemetry.reportAttackDiscoveryGenerationFailure)({
      apiConfig,
      errorMessage: error.message,
      telemetry
    });
  } catch (updateErr) {
    const updateError = (0, _securitysolutionEsUtils.transformError)(updateErr);
    logger.error(`handleGraphError: error reporting attack discovery generation failure ${updateError.message}`);
  }
};
exports.handleGraphError = handleGraphError;