"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCombinedAttackDiscoveryPrompt = void 0;
var _fp = require("lodash/fp");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// NOTE: we ask the LLM to `provide insights`. We do NOT use the feature name, `AttackDiscovery`, in the prompt.
const getAlertsContextPrompt = ({
  anonymizedAlerts,
  attackDiscoveryPrompt
}) => `${attackDiscoveryPrompt}

Use context from the following alerts to provide insights:

"""
${anonymizedAlerts.join('\n\n')}
"""
`;

/**
 * Returns the the initial query, or the initial query combined with a
 * continuation prompt and partial results
 */
const getCombinedAttackDiscoveryPrompt = ({
  anonymizedDocs,
  prompt,
  combinedMaybePartialResults,
  continuePrompt
}) => {
  const alertsContextPrompt = getAlertsContextPrompt({
    anonymizedAlerts: anonymizedDocs,
    attackDiscoveryPrompt: prompt
  });
  return (0, _fp.isEmpty)(combinedMaybePartialResults) ? alertsContextPrompt // no partial results yet
  : `${alertsContextPrompt}

${continuePrompt}

"""
${combinedMaybePartialResults}
"""

`;
};
exports.getCombinedAttackDiscoveryPrompt = getCombinedAttackDiscoveryPrompt;