"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSpaceId = void 0;
var _react = require("react");
var _typed_kibana_context = require("../../context/typed_kibana_context/typed_kibana_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSpaceId = () => {
  const {
    spaces
  } = (0, _typed_kibana_context.useKibana)().services;
  const [spaceId, setSpaceId] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    if (spaces) {
      spaces.getActiveSpace().then(space => setSpaceId(space.id));
    }
  }, [spaces]);
  return spaceId;
};
exports.useSpaceId = useSpaceId;