"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsNavControlVisible = useIsNavControlVisible;
var _react = require("react");
var _rxjs = require("rxjs");
var _public = require("@kbn/core/public");
var _public2 = require("@kbn/ai-assistant-management-plugin/public");
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _typed_kibana_context = require("../../context/typed_kibana_context/typed_kibana_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getVisibility(appId, applications, preferredAssistantType, chatExperience, space, isServerless) {
  var _applications$get, _applications$get$cat;
  // If AI Agents are enabled, hide the nav control
  // OnechatNavControl will be used instead
  if (chatExperience === _public2.AIChatExperience.Agent) {
    return false;
  }

  // If the app itself is enabled, always show the control in the solution view or serverless.
  if (space.solution === 'security' || isServerless) {
    return true;
  }
  if (preferredAssistantType === _public2.AIAssistantType.Never) {
    return false;
  }
  const categoryId = appId && ((_applications$get = applications.get(appId)) === null || _applications$get === void 0 ? void 0 : (_applications$get$cat = _applications$get.category) === null || _applications$get$cat === void 0 ? void 0 : _applications$get$cat.id) || _public.DEFAULT_APP_CATEGORIES.kibana.id;
  if (preferredAssistantType === _public2.AIAssistantType.Security) {
    return _public.DEFAULT_APP_CATEGORIES.observability.id !== categoryId && _public.DEFAULT_APP_CATEGORIES.enterpriseSearch.id !== categoryId;
  }
  return _public.DEFAULT_APP_CATEGORIES.security.id === categoryId;
}
function useIsNavControlVisible(isServerless) {
  const {
    application: {
      currentAppId$,
      applications$
    },
    settings,
    aiAssistantManagementSelection,
    spaces
  } = (0, _typed_kibana_context.useKibana)().services;
  const [isVisible, setIsVisible] = (0, _react.useState)(false);
  const space$ = spaces.getActiveSpace$();
  (0, _react.useEffect)(() => {
    const chatExperience$ = settings.client.get$(_managementSettingsIds.AI_CHAT_EXPERIENCE_TYPE);
    const appSubscription = (0, _rxjs.combineLatest)([currentAppId$, applications$, aiAssistantManagementSelection.aiAssistantType$, chatExperience$, space$]).subscribe({
      next: ([appId, applications, preferredAssistantType, chatExperience, space]) => {
        setIsVisible(getVisibility(appId, applications, preferredAssistantType, chatExperience, space, isServerless));
      }
    });
    return () => appSubscription.unsubscribe();
  }, [currentAppId$, applications$, aiAssistantManagementSelection.aiAssistantType$, settings.client, space$, isServerless]);
  return {
    isVisible
  };
}