"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuggestUsersResponse = exports.SuggestUsersRequestBody = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Suggest users API
 *   version: 1
 */

const SuggestUsersRequestBody = exports.SuggestUsersRequestBody = _zod.z.object({
  /**
   * Search term to filter users
   */
  searchTerm: _zod.z.string().optional(),
  /**
   * Number of users to return
   */
  size: _zod.z.number().optional()
});

/**
 * Array of user profiles
 */

const SuggestUsersResponse = exports.SuggestUsersResponse = _zod.z.array(_zod.z.object({
  /**
   * A unique identifier for the user profile.
   */
  uid: _zod.z.string(),
  /**
   * Indicates whether user profile is enabled or not.
   */
  enabled: _zod.z.boolean(),
  /**
   * User specific data associated with the profile.
   */
  data: _zod.z.object({}).catchall(_zod.z.unknown()),
  /**
   * Information about the user that owns profile.
   */
  user: _zod.z.object({
    /**
     * The username of the user.
     */
    username: _zod.z.string(),
    /**
     * The full name of the user.
     */
    full_name: _zod.z.string().optional(),
    /**
     * The email address of the user.
     */
    email: _zod.z.string().optional()
  })
}));