"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.replaceOriginalValuesWithUuidValues = exports.replaceAnonymizedValuesWithOriginalValues = exports.isDenied = exports.isAnonymized = exports.isAllowed = exports.getIsDataAnonymizable = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getIsDataAnonymizable = rawData => typeof rawData !== 'string';
exports.getIsDataAnonymizable = getIsDataAnonymizable;
const isAllowed = ({
  anonymizationFields,
  field
}) => {
  var _anonymizationFields$, _anonymizationFields$2;
  return (_anonymizationFields$ = (_anonymizationFields$2 = anonymizationFields.find(a => a.field === field)) === null || _anonymizationFields$2 === void 0 ? void 0 : _anonymizationFields$2.allowed) !== null && _anonymizationFields$ !== void 0 ? _anonymizationFields$ : false;
};
exports.isAllowed = isAllowed;
const isDenied = ({
  anonymizationFields,
  field
}) => {
  var _anonymizationFields$3, _anonymizationFields$4;
  return !((_anonymizationFields$3 = (_anonymizationFields$4 = anonymizationFields.find(a => a.field === field)) === null || _anonymizationFields$4 === void 0 ? void 0 : _anonymizationFields$4.allowed) !== null && _anonymizationFields$3 !== void 0 ? _anonymizationFields$3 : false);
};
exports.isDenied = isDenied;
const isAnonymized = ({
  anonymizationFields,
  field
}) => {
  var _anonymizationFields$5, _anonymizationFields$6;
  return (_anonymizationFields$5 = (_anonymizationFields$6 = anonymizationFields.find(a => a.field === field)) === null || _anonymizationFields$6 === void 0 ? void 0 : _anonymizationFields$6.anonymized) !== null && _anonymizationFields$5 !== void 0 ? _anonymizationFields$5 : false;
};
exports.isAnonymized = isAnonymized;
const replaceAnonymizedValuesWithOriginalValues = ({
  messageContent,
  replacements
}) => replacements != null ? Object.keys(replacements).reduce((acc, key) => {
  const value = replacements[key];
  return acc.replaceAll(key, value);
}, messageContent) : messageContent;
exports.replaceAnonymizedValuesWithOriginalValues = replaceAnonymizedValuesWithOriginalValues;
const replaceOriginalValuesWithUuidValues = ({
  messageContent,
  replacements
}) => replacements != null ? Object.keys(replacements).reduce((acc, key) => {
  const value = replacements[key];
  return value ? acc.replaceAll(value, key) : acc;
}, messageContent) : messageContent;
exports.replaceOriginalValuesWithUuidValues = replaceOriginalValuesWithUuidValues;