"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolveConnectorId = exports.OUTDATED_ELASTIC_MANAGED_CONNECTOR_IDS = exports.LATEST_ELASTIC_MANAGED_CONNECTOR_ID = exports.GENERAL_PURPOSE_LLM_V2_CONNECTOR_ID = exports.GENERAL_PURPOSE_LLM_V1_CONNECTOR_ID = exports.ELASTIC_MANAGED_LLM_CONNECTOR_ID = exports.ANTHROPIC_CLAUDE_SONNET_4_5_CONNECTOR_ID = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ELASTIC_MANAGED_LLM_CONNECTOR_ID = exports.ELASTIC_MANAGED_LLM_CONNECTOR_ID = 'Elastic-Managed-LLM';
const GENERAL_PURPOSE_LLM_V1_CONNECTOR_ID = exports.GENERAL_PURPOSE_LLM_V1_CONNECTOR_ID = 'General-Purpose-LLM-v1';
const GENERAL_PURPOSE_LLM_V2_CONNECTOR_ID = exports.GENERAL_PURPOSE_LLM_V2_CONNECTOR_ID = 'General-Purpose-LLM-v2';
const ANTHROPIC_CLAUDE_SONNET_4_5_CONNECTOR_ID = exports.ANTHROPIC_CLAUDE_SONNET_4_5_CONNECTOR_ID = 'Anthropic-Claude-Sonnet-4-5';
const OUTDATED_ELASTIC_MANAGED_CONNECTOR_IDS = exports.OUTDATED_ELASTIC_MANAGED_CONNECTOR_IDS = [ELASTIC_MANAGED_LLM_CONNECTOR_ID, GENERAL_PURPOSE_LLM_V1_CONNECTOR_ID];
const LATEST_ELASTIC_MANAGED_CONNECTOR_ID = exports.LATEST_ELASTIC_MANAGED_CONNECTOR_ID = ANTHROPIC_CLAUDE_SONNET_4_5_CONNECTOR_ID;
const resolveConnectorId = connectorId => {
  if (OUTDATED_ELASTIC_MANAGED_CONNECTOR_IDS.includes(connectorId)) {
    return LATEST_ELASTIC_MANAGED_CONNECTOR_ID;
  }
  return connectorId;
};
exports.resolveConnectorId = resolveConnectorId;