"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogFieldWithFallback = void 0;
var _lodash = require("lodash");
var _get_field_value_with_fallback = require("./get_field_value_with_fallback");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getLogFieldWithFallback = (doc, rankingOrder, options = {}) => {
  const {
    includeFormattedValue = false,
    includeOriginalValue = false
  } = options;
  const {
    field,
    value
  } = (0, _get_field_value_with_fallback.getFirstAvailableFieldValue)(doc, rankingOrder);
  const valueAsString = value !== undefined && value !== null ? String(value) : undefined;
  if (field && valueAsString !== undefined && valueAsString !== null) {
    let formattedValue;
    if (includeFormattedValue) {
      try {
        formattedValue = JSON.stringify(JSON.parse((0, _lodash.unescape)(valueAsString)), null, 2);
      } catch {
        // If the value is not a valid JSON, leave it unformatted
      }
    }
    return {
      field,
      value: valueAsString,
      formattedValue,
      originalValue: includeOriginalValue ? value : undefined
    };
  }

  // If none of the ranks (fallbacks) are present
  return {
    field: undefined
  };
};
exports.getLogFieldWithFallback = getLogFieldWithFallback;