"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dismissFlyouts = exports.dismissAllFlyoutsExceptFor = exports.DiscoverFlyouts = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
let DiscoverFlyouts = exports.DiscoverFlyouts = /*#__PURE__*/function (DiscoverFlyouts) {
  DiscoverFlyouts["lensEdit"] = "lensEdit";
  DiscoverFlyouts["docViewer"] = "docViewer";
  DiscoverFlyouts["esqlDocs"] = "esqlDocs";
  DiscoverFlyouts["metricInsights"] = "metricInsights";
  DiscoverFlyouts["esqlControls"] = "esqlControls";
  DiscoverFlyouts["lensAlertRule"] = "lensAlertRule";
  DiscoverFlyouts["inspectorPanel"] = "inspectorPanel";
  return DiscoverFlyouts;
}({});
const AllDiscoverFlyouts = Object.values(DiscoverFlyouts);
const getFlyoutCloseButtonGetters = flyout => {
  switch (flyout) {
    case DiscoverFlyouts.lensEdit:
      return [() => document.querySelector('[data-test-subj="lnsEditOnFlyFlyout"] [data-test-subj="lns-indexPattern-dimensionContainerBack"]'), () => document.getElementById('lnsCancelEditOnFlyFlyout')];
    case DiscoverFlyouts.docViewer:
      return [() => document.querySelector('[data-test-subj="docViewerFlyout"] [data-test-subj="euiFlyoutCloseButton"]')];
    case DiscoverFlyouts.esqlDocs:
      return [() => document.querySelector('[data-test-subj="esqlInlineDocumentationFlyout"] [data-test-subj="euiFlyoutCloseButton"]')];
    case DiscoverFlyouts.metricInsights:
      return [() => document.querySelector('[data-test-subj="metricsExperienceFlyout"] [data-test-subj="euiFlyoutCloseButton"]')];
    case DiscoverFlyouts.esqlControls:
      return [() => document.querySelector('[data-test-subj="esqlControlsFlyout"] [data-test-subj="euiFlyoutCloseButton"]')];
    case DiscoverFlyouts.lensAlertRule:
      return [() => document.querySelector('[data-test-subj="lensAlertRule"] [data-test-subj="euiFlyoutCloseButton"]')];
    case DiscoverFlyouts.inspectorPanel:
      return [() => document.querySelector('[data-test-subj="inspectorPanel"] [data-test-subj="euiFlyoutCloseButton"]')];
  }
};
const dismissFlyouts = (selectedFlyouts = AllDiscoverFlyouts, excludedFlyout) => {
  selectedFlyouts.forEach(flyout => {
    if (flyout === excludedFlyout) {
      return;
    }
    const closeButtonGetters = getFlyoutCloseButtonGetters(flyout);
    closeButtonGetters.forEach(getCloseButton => {
      const closeButton = getCloseButton();
      closeButton === null || closeButton === void 0 ? void 0 : closeButton.click();
    });
  });
};
exports.dismissFlyouts = dismissFlyouts;
const dismissAllFlyoutsExceptFor = excludedFlyout => {
  dismissFlyouts(AllDiscoverFlyouts, excludedFlyout);
};
exports.dismissAllFlyoutsExceptFor = dismissAllFlyoutsExceptFor;