"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FeaturesRegistry = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class FeaturesRegistry {
  constructor() {
    (0, _defineProperty2.default)(this, "features", new Map());
  }
  register(feature) {
    if (this.features.has(feature.id)) {
      throw new Error(`FeaturesRegistry#register: feature with id "${feature.id}" already exists in the registry.`);
    }
    this.features.set(feature.id, feature);
  }
  getById(id) {
    return this.features.get(id);
  }
}
exports.FeaturesRegistry = FeaturesRegistry;