"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serializeState = exports.deserializeState = void 0;
var _lodash = require("lodash");
var _reactFastCompare = _interopRequireDefault(require("react-fast-compare"));
var _common = require("@kbn/saved-search-plugin/common");
var _constants = require("../../../common/embeddable/constants");
var _constants2 = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const deserializeState = async ({
  serializedState,
  discoverServices
}) => {
  const panelState = (0, _lodash.pick)(serializedState.rawState, _constants2.EDITABLE_PANEL_KEYS);
  const savedObjectId = serializedState.rawState.savedObjectId;
  if (savedObjectId) {
    // by reference
    const {
      get
    } = discoverServices.savedSearch;
    const so = await get(savedObjectId, true);
    const rawSavedObjectAttributes = (0, _lodash.pick)(so, _constants.EDITABLE_SAVED_SEARCH_KEYS);
    const savedObjectOverride = (0, _lodash.pick)(serializedState.rawState, _constants.EDITABLE_SAVED_SEARCH_KEYS);
    return {
      // ignore the time range from the saved object - only global time range + panel time range matter
      ...(0, _lodash.omit)(so, 'timeRange'),
      savedObjectId,
      savedObjectTitle: so.title,
      savedObjectDescription: so.description,
      // Overwrite SO state with dashboard state for title, description, columns, sort, etc.
      ...panelState,
      ...savedObjectOverride,
      // back up the original saved object attributes for comparison
      rawSavedObjectAttributes
    };
  } else {
    // by value
    const {
      byValueToSavedSearch
    } = discoverServices.savedSearch;
    const savedSearch = await byValueToSavedSearch(serializedState.rawState, true);
    return {
      ...savedSearch,
      ...panelState,
      nonPersistedDisplayOptions: serializedState.rawState.nonPersistedDisplayOptions
    };
  }
};
exports.deserializeState = deserializeState;
const serializeState = ({
  uuid,
  initialState,
  savedSearch,
  serializeTitles,
  serializeTimeRange,
  serializeDynamicActions,
  savedObjectId
}) => {
  const searchSource = savedSearch.searchSource;
  const {
    searchSourceJSON,
    references: originalReferences
  } = searchSource.serialize();
  const savedSearchAttributes = (0, _common.toSavedSearchAttributes)(savedSearch, searchSourceJSON);
  if (savedObjectId) {
    var _initialState$rawSave;
    const editableAttributesBackup = (_initialState$rawSave = initialState.rawSavedObjectAttributes) !== null && _initialState$rawSave !== void 0 ? _initialState$rawSave : {};
    const [{
      attributes
    }] = savedSearchAttributes.tabs;

    // only save the current state that is **different** than the saved object state
    const overwriteState = _constants.EDITABLE_SAVED_SEARCH_KEYS.reduce((prev, key) => {
      if ((0, _reactFastCompare.default)(attributes[key], editableAttributesBackup[key])) {
        return prev;
      }
      return {
        ...prev,
        [key]: attributes[key]
      };
    }, {});
    return {
      rawState: {
        // Serialize the current dashboard state into the panel state **without** updating the saved object
        ...serializeTitles(),
        ...serializeTimeRange(),
        ...(serializeDynamicActions === null || serializeDynamicActions === void 0 ? void 0 : serializeDynamicActions()),
        ...overwriteState,
        savedObjectId
      },
      references: []
    };
  }
  const state = {
    attributes: {
      ...savedSearchAttributes,
      references: originalReferences
    }
  };
  return {
    rawState: {
      ...serializeTitles(),
      ...serializeTimeRange(),
      ...(serializeDynamicActions === null || serializeDynamicActions === void 0 ? void 0 : serializeDynamicActions()),
      ...state
    },
    references: []
  };
};
exports.serializeState = serializeState;