"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isFieldStatsMode = isFieldStatsMode;
var _discoverUtils = require("@kbn/discover-utils");
var _common = require("@kbn/saved-search-plugin/common");
var _get_valid_view_mode = require("../../application/main/utils/get_valid_view_mode");
var _initialize_fetch = require("../initialize_fetch");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function isFieldStatsMode(savedSearch, dataView, uiSettings) {
  const validatedViewMode = (0, _get_valid_view_mode.getValidViewMode)({
    viewMode: savedSearch.viewMode,
    isEsqlMode: (0, _initialize_fetch.isEsqlMode)(savedSearch)
  });
  return Boolean(uiSettings.get(_discoverUtils.SHOW_FIELD_STATISTICS)) && validatedViewMode === _common.VIEW_MODE.AGGREGATED_LEVEL && Boolean(dataView) && Array.isArray(savedSearch.columns);
}