"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDiscoverCustomization$ = exports.useDiscoverCustomization = exports.getExtendedDiscoverStateContainer = exports.getConnectedCustomizationService = exports.DiscoverCustomizationProvider = void 0;
var _react = require("react");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _lodash = require("lodash");
var _customization_service = require("./customization_service");
var _get_initial_app_state = require("../application/main/state_management/utils/get_initial_app_state");
var _redux = require("../application/main/state_management/redux");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const customizationContext = /*#__PURE__*/(0, _react.createContext)((0, _customization_service.createCustomizationService)());
const DiscoverCustomizationProvider = exports.DiscoverCustomizationProvider = customizationContext.Provider;
const useDiscoverCustomization$ = id => (0, _react.useContext)(customizationContext).get$(id);
exports.useDiscoverCustomization$ = useDiscoverCustomization$;
const useDiscoverCustomization = id => {
  const customizationService = (0, _react.useContext)(customizationContext);
  return (0, _useObservable.default)(customizationService.get$(id), customizationService.get(id));
};
exports.useDiscoverCustomization = useDiscoverCustomization;
const getExtendedDiscoverStateContainer = (stateContainer, services) => ({
  ...stateContainer,
  getAppStateFromSavedSearch: newSavedSearch => {
    return (0, _get_initial_app_state.getInitialAppState)({
      initialUrlState: undefined,
      persistedTab: (0, _redux.fromSavedSearchToSavedObjectTab)({
        tab: stateContainer.getCurrentTab(),
        savedSearch: newSavedSearch,
        services
      }),
      dataView: newSavedSearch.searchSource.getField('index'),
      services
    });
  }
});
exports.getExtendedDiscoverStateContainer = getExtendedDiscoverStateContainer;
const getConnectedCustomizationService = async ({
  customizationCallbacks,
  stateContainer: originalStateContainer,
  services
}) => {
  const customizations = (0, _customization_service.createCustomizationService)();
  const stateContainer = getExtendedDiscoverStateContainer(originalStateContainer, services);
  const callbacks = customizationCallbacks.map(callback => Promise.resolve(callback({
    customizations,
    stateContainer
  })));
  const initialize = () => Promise.all(callbacks).then(result => result.filter(_lodash.isFunction));

  // TODO: Race condition?
  await initialize();
  return {
    ...customizations,
    cleanup: async () => {
      const cleanups = await initialize();
      cleanups.forEach(cleanup => cleanup());
    }
  };
};
exports.getConnectedCustomizationService = getConnectedCustomizationService;