"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createIntegrationLogsDataSourceProfileProviders = void 0;
var _discoverUtils = require("@kbn/discover-utils");
var _consts = require("../consts");
var _extend_profile_provider = require("../../../extend_profile_provider");
var _accessors = require("../accessors");
var _create_resolve = require("./create_resolve");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const integrationLogsProfileProviders = [{
  profileId: 'observability-apache-error-logs-data-source-profile',
  baseIndexPattern: _discoverUtils.APACHE_ERROR_LOGS_PROFILE.pattern,
  defaultAppState: {
    defaultColumns: [_consts.LOG_LEVEL_COLUMN, _consts.CLIENT_IP_COLUMN, _consts.MESSAGE_COLUMN]
  },
  recommendedFields: [..._discoverUtils.APACHE_ERROR_LOGS_PROFILE.recommendedFields]
}, {
  profileId: 'observability-aws-s3access-logs-data-source-profile',
  baseIndexPattern: 'logs-aws.s3access',
  defaultAppState: {
    defaultColumns: [{
      name: 'aws.s3.bucket.name',
      width: 200
    }, {
      name: 'aws.s3.object.key',
      width: 200
    }, {
      name: 'aws.s3access.operation',
      width: 200
    }, _consts.CLIENT_IP_COLUMN, _consts.MESSAGE_COLUMN]
  }
}, {
  profileId: 'observability-kubernetes-container-logs-data-source-profile',
  baseIndexPattern: _discoverUtils.KUBERNETES_CONTAINER_LOGS_PROFILE.pattern,
  defaultAppState: {
    defaultColumns: [_consts.LOG_LEVEL_COLUMN, {
      name: 'kubernetes.pod.name',
      width: 200
    }, {
      name: 'kubernetes.namespace',
      width: 200
    }, {
      name: 'orchestrator.cluster.name',
      width: 200
    }, _consts.MESSAGE_COLUMN]
  },
  recommendedFields: [..._discoverUtils.KUBERNETES_CONTAINER_LOGS_PROFILE.recommendedFields]
}, {
  profileId: 'observability-nginx-access-logs-data-source-profile',
  baseIndexPattern: 'logs-nginx.access',
  defaultAppState: {
    defaultColumns: [{
      name: 'url.path',
      width: 150
    }, {
      name: 'http.response.status_code',
      width: 200
    }, _consts.CLIENT_IP_COLUMN, _consts.HOST_NAME_COLUMN, _consts.MESSAGE_COLUMN]
  }
}, {
  profileId: 'observability-nginx-error-logs-data-source-profile',
  baseIndexPattern: 'logs-nginx.error',
  defaultAppState: {
    defaultColumns: [_consts.LOG_LEVEL_COLUMN, _consts.MESSAGE_COLUMN]
  }
}, {
  profileId: 'observability-system-logs-data-source-profile',
  baseIndexPattern: 'logs-system',
  defaultAppState: {
    defaultColumns: [_consts.LOG_LEVEL_COLUMN, {
      name: 'process.name',
      width: 150
    }, _consts.HOST_NAME_COLUMN, _consts.MESSAGE_COLUMN]
  }
}, {
  profileId: 'observability-windows-logs-data-source-profile',
  baseIndexPattern: 'logs-windows',
  defaultAppState: {
    defaultColumns: [_consts.LOG_LEVEL_COLUMN, _consts.HOST_NAME_COLUMN, _consts.MESSAGE_COLUMN]
  }
}];
const createIntegrationLogsDataSourceProfileProviders = logsDataSourceProfileProvider => {
  return integrationLogsProfileProviders.map(({
    profileId,
    baseIndexPattern,
    defaultAppState,
    recommendedFields
  }) => (0, _extend_profile_provider.extendProfileProvider)(logsDataSourceProfileProvider, {
    profileId,
    profile: {
      getDefaultAppState: (0, _accessors.createGetDefaultAppState)(defaultAppState),
      ...(recommendedFields ? {
        getRecommendedFields: (0, _accessors.createRecommendedFields)({
          defaultFields: recommendedFields
        })
      } : {})
    },
    resolve: (0, _create_resolve.createResolve)(baseIndexPattern)
  }));
};
exports.createIntegrationLogsDataSourceProfileProviders = createIntegrationLogsDataSourceProfileProviders;