"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDiscoverHistogram = void 0;
var _unifiedHistogram = require("@kbn/unified-histogram");
var _lodash = require("lodash");
var _react = require("react");
var _rxjs = require("rxjs");
var _useLatest = _interopRequireDefault(require("react-use/lib/useLatest"));
var _common = require("@kbn/data-plugin/common");
var _context_awareness = require("../../../../context_awareness");
var _customizations = require("../../../../customizations");
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _types = require("../../../types");
var _use_saved_search_messages = require("../../hooks/use_saved_search_messages");
var _redux = require("../../state_management/redux");
var _discover_state_provider = require("../../state_management/discover_state_provider");
var _use_is_esql_mode = require("../../hooks/use_is_esql_mode");
var _use_data_state = require("../../hooks/use_data_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const EMPTY_ESQL_COLUMNS = [];
const EMPTY_FILTERS = [];
const TAB_ATTRIBUTE_TO_TRIGGER_CHART_FETCH = ['externalVisContext', 'breakdownField', 'timeInterval'];
const useDiscoverHistogram = (stateContainer, options) => {
  var _options$initialLayou2;
  const services = (0, _use_discover_services.useDiscoverServices)();
  const {
    data$: {
      main$,
      documents$,
      totalHits$
    },
    inspectorAdapters,
    getAbortController
  } = stateContainer.dataState;
  const savedSearchState = (0, _discover_state_provider.useSavedSearch)();
  const isEsqlMode = (0, _use_is_esql_mode.useIsEsqlMode)();
  const dispatch = (0, _redux.useInternalStateDispatch)();
  const updateAppState = (0, _redux.useCurrentTabAction)(_redux.internalStateActions.updateAppState);
  const documentsState = (0, _use_data_state.useDataState)(documents$);
  const isChartLoading = (0, _react.useMemo)(() => {
    return isEsqlMode && (documentsState === null || documentsState === void 0 ? void 0 : documentsState.fetchStatus) === _types.FetchStatus.LOADING;
  }, [isEsqlMode, documentsState === null || documentsState === void 0 ? void 0 : documentsState.fetchStatus]);

  /**
   * API initialization
   */

  const [unifiedHistogramApi, setUnifiedHistogramApi] = (0, _react.useState)();

  /**
   * Sync Unified Histogram state with Discover state
   */

  (0, _react.useEffect)(() => {
    var _createUnifiedHistogr;
    const subscription = (_createUnifiedHistogr = createUnifiedHistogramStateObservable(unifiedHistogramApi === null || unifiedHistogramApi === void 0 ? void 0 : unifiedHistogramApi.state$)) === null || _createUnifiedHistogr === void 0 ? void 0 : _createUnifiedHistogr.subscribe(changes => {
      const {
        lensRequestAdapter,
        ...stateChanges
      } = changes;
      const appState = stateContainer.getCurrentTab().appState;
      const oldState = {
        hideChart: appState.hideChart
      };
      const newState = {
        ...oldState,
        ...stateChanges
      };
      if ('lensRequestAdapter' in changes) {
        inspectorAdapters.lensRequests = lensRequestAdapter;
      }
      if (!(0, _lodash.isEqual)(oldState, newState)) {
        dispatch(updateAppState({
          appState: newState
        }));
      }
    });
    return () => {
      subscription === null || subscription === void 0 ? void 0 : subscription.unsubscribe();
    };
  }, [dispatch, inspectorAdapters, stateContainer, unifiedHistogramApi === null || unifiedHistogramApi === void 0 ? void 0 : unifiedHistogramApi.state$, updateAppState]);

  /**
   * Sync URL query params with Unified Histogram
   */

  (0, _react.useEffect)(() => {
    const subscription = createAppStateObservable(stateContainer.appState$).subscribe(changes => {
      if ('chartHidden' in changes && typeof changes.chartHidden === 'boolean') {
        unifiedHistogramApi === null || unifiedHistogramApi === void 0 ? void 0 : unifiedHistogramApi.setChartHidden(changes.chartHidden);
      }
    });
    return () => {
      subscription === null || subscription === void 0 ? void 0 : subscription.unsubscribe();
    };
  }, [stateContainer.appState$, unifiedHistogramApi]);

  /**
   * Total hits
   */

  const setTotalHitsError = (0, _react.useMemo)(() => (0, _use_saved_search_messages.sendErrorTo)(totalHits$), [totalHits$]);
  (0, _react.useEffect)(() => {
    var _createTotalHitsObser;
    const subscription = (_createTotalHitsObser = createTotalHitsObservable(unifiedHistogramApi === null || unifiedHistogramApi === void 0 ? void 0 : unifiedHistogramApi.state$)) === null || _createTotalHitsObser === void 0 ? void 0 : _createTotalHitsObser.subscribe(({
      status,
      result
    }) => {
      if (isEsqlMode) {
        // ignore histogram's total hits updates for ES|QL as Discover manages them during docs fetching
        return;
      }
      if (result instanceof Error) {
        // Set totalHits$ to an error state
        setTotalHitsError(result);
        return;
      }
      const {
        result: totalHitsResult
      } = totalHits$.getValue();
      if ((status === _unifiedHistogram.UnifiedHistogramFetchStatus.loading || status === _unifiedHistogram.UnifiedHistogramFetchStatus.uninitialized) && totalHitsResult && typeof result !== 'number') {
        // ignore the histogram initial loading state if discover state already has a total hits value
        return;
      }
      const fetchStatus = status.toString();

      // Do not sync the loading state since it's already handled by fetchAll
      if (fetchStatus !== _types.FetchStatus.LOADING) {
        totalHits$.next({
          fetchStatus,
          result
        });
      }
      if (status !== _unifiedHistogram.UnifiedHistogramFetchStatus.complete || typeof result !== 'number') {
        return;
      }

      // Check the hits count to set a partial or no results state
      (0, _use_saved_search_messages.checkHitCount)(main$, result);
    });
    return () => {
      subscription === null || subscription === void 0 ? void 0 : subscription.unsubscribe();
    };
  }, [isEsqlMode, main$, totalHits$, setTotalHitsError, unifiedHistogramApi === null || unifiedHistogramApi === void 0 ? void 0 : unifiedHistogramApi.state$]);

  /**
   * Request params
   */
  const requestParams = (0, _redux.useCurrentTabSelector)(state => state.dataRequestParams);
  const currentTabControlState = (0, _redux.useCurrentTabSelector)(tab => tab.controlGroupState);
  const {
    timeRangeRelative: relativeTimeRange,
    timeRangeAbsolute: timeRange,
    searchSessionId
  } = requestParams;
  const dataView = (0, _redux.useCurrentDataView)();
  const histogramCustomization = (0, _customizations.useDiscoverCustomization)('unified_histogram');
  const query = (0, _redux.useAppStateSelector)(state => state.query);
  const appFilters = (0, _redux.useAppStateSelector)(state => state.filters);
  const {
    filters: globalFilters
  } = (0, _redux.useCurrentTabSelector)(state => state.globalState);
  const filtersMemoized = (0, _react.useMemo)(() => {
    const allFilters = [...(globalFilters !== null && globalFilters !== void 0 ? globalFilters : []), ...(appFilters !== null && appFilters !== void 0 ? appFilters : [])];
    return allFilters.length ? allFilters : EMPTY_FILTERS;
  }, [appFilters, globalFilters]);
  const chartHidden = (0, _redux.useAppStateSelector)(state => state.hideChart);
  const timeInterval = (0, _redux.useAppStateSelector)(state => state.interval);
  const breakdownField = (0, _redux.useAppStateSelector)(state => state.breakdownField);
  const esqlVariables = (0, _redux.useCurrentTabSelector)(tab => tab.esqlVariables);
  const getModifiedVisAttributesAccessor = (0, _context_awareness.useProfileAccessor)('getModifiedVisAttributes');
  const getModifiedVisAttributes = (0, _react.useCallback)(attributes => getModifiedVisAttributesAccessor(params => params.attributes)({
    attributes
  }), [getModifiedVisAttributesAccessor]);
  const collectedFetchParams = (0, _react.useMemo)(() => {
    return {
      searchSessionId,
      requestAdapter: inspectorAdapters.requests,
      dataView,
      query,
      filters: isEsqlMode ? EMPTY_FILTERS : filtersMemoized,
      timeRange,
      relativeTimeRange,
      breakdownField,
      timeInterval,
      esqlVariables,
      controlsState: currentTabControlState,
      // visContext should be in sync with current query
      externalVisContext: isEsqlMode && (0, _unifiedHistogram.canImportVisContext)(savedSearchState === null || savedSearchState === void 0 ? void 0 : savedSearchState.visContext) ? savedSearchState === null || savedSearchState === void 0 ? void 0 : savedSearchState.visContext : undefined,
      getModifiedVisAttributes
    };
  }, [breakdownField, timeInterval, currentTabControlState, dataView, esqlVariables, filtersMemoized, inspectorAdapters.requests, isEsqlMode, timeRange, relativeTimeRange, searchSessionId, query, savedSearchState === null || savedSearchState === void 0 ? void 0 : savedSearchState.visContext, getModifiedVisAttributes]);
  const previousFetchParamsRef = (0, _react.useRef)(null);
  const triggerUnifiedHistogramFetch = (0, _useLatest.default)(latestFetchDetails => {
    var _collectedFetchParams, _latestFetchDetails$a;
    const visContext = (_collectedFetchParams = collectedFetchParams === null || collectedFetchParams === void 0 ? void 0 : collectedFetchParams.externalVisContext) !== null && _collectedFetchParams !== void 0 ? _collectedFetchParams : savedSearchState === null || savedSearchState === void 0 ? void 0 : savedSearchState.visContext;
    const {
      table,
      esqlQueryColumns
    } = getUnifiedHistogramTableForEsql({
      documentsValue: documents$.getValue(),
      isEsqlMode
    });
    const nextFetchParams = {
      ...collectedFetchParams,
      abortController: (_latestFetchDetails$a = latestFetchDetails === null || latestFetchDetails === void 0 ? void 0 : latestFetchDetails.abortController) !== null && _latestFetchDetails$a !== void 0 ? _latestFetchDetails$a : getAbortController(),
      columns: isEsqlMode ? esqlQueryColumns : undefined,
      table: isEsqlMode ? table : undefined,
      externalVisContext: isEsqlMode && (0, _unifiedHistogram.canImportVisContext)(visContext) ? visContext : undefined
    };
    previousFetchParamsRef.current = nextFetchParams;
    unifiedHistogramApi === null || unifiedHistogramApi === void 0 ? void 0 : unifiedHistogramApi.fetch(nextFetchParams);
  });

  /**
   * Data fetching
   */
  (0, _react.useEffect)(() => {
    if (!unifiedHistogramApi) {
      return;
    }
    const subscription = stateContainer.dataState.fetchChart$.subscribe(latestFetchDetails => {
      if (latestFetchDetails) {
        triggerUnifiedHistogramFetch.current(latestFetchDetails);
      }
    });
    return () => {
      subscription.unsubscribe();
    };
  }, [stateContainer.dataState.fetchChart$, triggerUnifiedHistogramFetch, unifiedHistogramApi]);
  (0, _react.useEffect)(() => {
    const previousFetchParams = previousFetchParamsRef.current;
    if (!collectedFetchParams || !previousFetchParams) {
      return;
    }
    const changedParams = Object.keys(collectedFetchParams).filter(key => {
      return collectedFetchParams[key] !== previousFetchParams[key];
    });
    if (changedParams.length > 0 && (0, _lodash.intersection)(changedParams, TAB_ATTRIBUTE_TO_TRIGGER_CHART_FETCH).length === changedParams.length) {
      // if changes happen only in the TAB_ATTRIBUTE_TO_TRIGGER_CHART_FETCH attributes, then trigger a separate chart refetch
      // as we know that for these attributes we don't refetch documents (hence no fetchChart$ emission will happen)
      triggerUnifiedHistogramFetch.current(undefined);
    }
  }, [collectedFetchParams, triggerUnifiedHistogramFetch]);
  const setOverriddenVisContextAfterInvalidation = (0, _redux.useCurrentTabAction)(_redux.internalStateActions.setOverriddenVisContextAfterInvalidation);
  const onVisContextChanged = (0, _react.useCallback)((nextVisContext, externalVisContextStatus) => {
    switch (externalVisContextStatus) {
      case _unifiedHistogram.UnifiedHistogramExternalVisContextStatus.manuallyCustomized:
        // if user customized the visualization manually
        // (only this action should trigger Unsaved changes badge)
        stateContainer.savedSearchState.updateVisContext({
          nextVisContext
        });
        dispatch(setOverriddenVisContextAfterInvalidation({
          overriddenVisContextAfterInvalidation: undefined
        }));
        break;
      case _unifiedHistogram.UnifiedHistogramExternalVisContextStatus.automaticallyOverridden:
        // if the visualization was invalidated as incompatible and rebuilt
        // (it will be used later for saving the visualization via Save button)
        dispatch(setOverriddenVisContextAfterInvalidation({
          overriddenVisContextAfterInvalidation: nextVisContext
        }));
        break;
      case _unifiedHistogram.UnifiedHistogramExternalVisContextStatus.automaticallyCreated:
      case _unifiedHistogram.UnifiedHistogramExternalVisContextStatus.applied:
        // clearing the value in the internal state so we don't use it during saved search saving
        dispatch(setOverriddenVisContextAfterInvalidation({
          overriddenVisContextAfterInvalidation: undefined
        }));
        break;
      case _unifiedHistogram.UnifiedHistogramExternalVisContextStatus.unknown:
        // using `{}` to overwrite the value inside the saved search SO during saving
        dispatch(setOverriddenVisContextAfterInvalidation({
          overriddenVisContextAfterInvalidation: {}
        }));
        break;
    }
  }, [dispatch, setOverriddenVisContextAfterInvalidation, stateContainer.savedSearchState]);
  const onBreakdownFieldChange = (0, _react.useCallback)(nextBreakdownField => {
    if (nextBreakdownField !== breakdownField) {
      dispatch(updateAppState({
        appState: {
          breakdownField: nextBreakdownField
        }
      }));
    }
  }, [breakdownField, dispatch, updateAppState]);
  const onTimeIntervalChange = (0, _react.useCallback)(nextTimeInterval => {
    if (nextTimeInterval !== timeInterval) {
      dispatch(updateAppState({
        appState: {
          interval: nextTimeInterval
        }
      }));
    }
  }, [timeInterval, dispatch, updateAppState]);
  return (0, _react.useMemo)(() => {
    var _options$initialLayou;
    return {
      setUnifiedHistogramApi,
      enableLensVisService: true,
      services,
      localStorageKeyPrefix: 'discover',
      initialState: {
        chartHidden,
        topPanelHeight: options === null || options === void 0 ? void 0 : (_options$initialLayou = options.initialLayoutProps) === null || _options$initialLayou === void 0 ? void 0 : _options$initialLayou.topPanelHeight,
        totalHitsStatus: _unifiedHistogram.UnifiedHistogramFetchStatus.loading,
        totalHitsResult: undefined
      },
      onFilter: histogramCustomization === null || histogramCustomization === void 0 ? void 0 : histogramCustomization.onFilter,
      onBrushEnd: histogramCustomization === null || histogramCustomization === void 0 ? void 0 : histogramCustomization.onBrushEnd,
      withDefaultActions: histogramCustomization === null || histogramCustomization === void 0 ? void 0 : histogramCustomization.withDefaultActions,
      disabledActions: histogramCustomization === null || histogramCustomization === void 0 ? void 0 : histogramCustomization.disabledActions,
      isChartLoading,
      onVisContextChanged: isEsqlMode ? onVisContextChanged : undefined,
      onBreakdownFieldChange,
      onTimeIntervalChange
    };
  }, [chartHidden, histogramCustomization === null || histogramCustomization === void 0 ? void 0 : histogramCustomization.disabledActions, histogramCustomization === null || histogramCustomization === void 0 ? void 0 : histogramCustomization.onBrushEnd, histogramCustomization === null || histogramCustomization === void 0 ? void 0 : histogramCustomization.onFilter, histogramCustomization === null || histogramCustomization === void 0 ? void 0 : histogramCustomization.withDefaultActions, isEsqlMode, isChartLoading, onBreakdownFieldChange, onTimeIntervalChange, onVisContextChanged, options === null || options === void 0 ? void 0 : (_options$initialLayou2 = options.initialLayoutProps) === null || _options$initialLayou2 === void 0 ? void 0 : _options$initialLayou2.topPanelHeight, services]);
};

// Use pairwise to diff the previous and current state (starting with undefined to ensure
// pairwise triggers after a single emission), and return an object containing only the
// changed properties. By only including the changed properties, we avoid accidentally
// overwriting other state properties that may have been updated between the time this
// obersverable was triggered and the time the state changes are applied.
exports.useDiscoverHistogram = useDiscoverHistogram;
const createUnifiedHistogramStateObservable = state$ => {
  return state$ === null || state$ === void 0 ? void 0 : state$.pipe((0, _rxjs.startWith)(undefined), (0, _rxjs.pairwise)(), (0, _rxjs.map)(([prev, curr]) => {
    const changes = {};
    if (!curr) {
      return changes;
    }
    if ((prev === null || prev === void 0 ? void 0 : prev.lensRequestAdapter) !== curr.lensRequestAdapter) {
      changes.lensRequestAdapter = curr.lensRequestAdapter;
    }
    if ((prev === null || prev === void 0 ? void 0 : prev.chartHidden) !== curr.chartHidden) {
      changes.hideChart = curr.chartHidden;
    }
    return changes;
  }), (0, _rxjs.filter)(changes => Object.keys(changes).length > 0));
};
const createAppStateObservable = state$ => {
  return state$.pipe((0, _rxjs.startWith)(undefined), (0, _rxjs.pairwise)(), (0, _rxjs.map)(([prev, curr]) => {
    const changes = {};
    if (!curr) {
      return changes;
    }
    if ((prev === null || prev === void 0 ? void 0 : prev.hideChart) !== curr.hideChart) {
      changes.chartHidden = curr.hideChart;
    }
    return changes;
  }), (0, _rxjs.filter)(changes => Object.keys(changes).length > 0));
};
const createTotalHitsObservable = state$ => {
  return state$ === null || state$ === void 0 ? void 0 : state$.pipe((0, _rxjs.map)(state => ({
    status: state.totalHitsStatus,
    result: state.totalHitsResult
  })), (0, _rxjs.distinctUntilChanged)((prev, curr) => prev.status === curr.status && prev.result === curr.result));
};
function getUnifiedHistogramTableForEsql({
  documentsValue,
  isEsqlMode
}) {
  if (!isEsqlMode || !(documentsValue !== null && documentsValue !== void 0 && documentsValue.result) || ![_types.FetchStatus.COMPLETE, _types.FetchStatus.ERROR].includes(documentsValue.fetchStatus)) {
    return {
      table: undefined,
      esqlQueryColumns: EMPTY_ESQL_COLUMNS
    };
  }
  const esqlQueryColumns = (documentsValue === null || documentsValue === void 0 ? void 0 : documentsValue.esqlQueryColumns) || EMPTY_ESQL_COLUMNS;
  return {
    table: {
      type: 'datatable',
      rows: documentsValue.result.map(r => r.raw),
      columns: esqlQueryColumns,
      meta: {
        type: _common.ESQL_TABLE_TYPE
      }
    },
    esqlQueryColumns
  };
}