"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SAVED_SEARCH_SAVED_OBJECT_REF_NAME = void 0;
exports.getTransformIn = getTransformIn;
var _common = require("@kbn/saved-search-plugin/common");
var _search_inject_extract = require("./search_inject_extract");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const SAVED_SEARCH_SAVED_OBJECT_REF_NAME = exports.SAVED_SEARCH_SAVED_OBJECT_REF_NAME = 'savedObjectRef';
function isByRefState(state) {
  return 'savedObjectId' in state;
}
function getTransformIn(transformEnhancementsIn) {
  function transformIn(state) {
    const {
      enhancementsState,
      enhancementsReferences
    } = state.enhancements ? transformEnhancementsIn(state.enhancements) : {
      enhancementsState: undefined,
      enhancementsReferences: []
    };
    if (isByRefState(state)) {
      const {
        savedObjectId,
        ...rest
      } = state;
      return {
        state: {
          ...rest,
          ...(enhancementsState ? {
            enhancements: enhancementsState
          } : {})
        },
        references: [{
          name: SAVED_SEARCH_SAVED_OBJECT_REF_NAME,
          type: _common.SavedSearchType,
          id: savedObjectId
        }, ...enhancementsReferences]
      };
    }

    // by value
    const {
      state: extractedState,
      references
    } = (0, _search_inject_extract.extract)({
      type: _common.SavedSearchType,
      attributes: state.attributes
    });
    return {
      state: {
        ...state,
        ...(enhancementsState ? {
          enhancements: enhancementsState
        } : {}),
        attributes: {
          ...state.attributes,
          ...extractedState.attributes,
          // discover session stores references as part of attributes
          references
        }
      },
      references: [...references, ...enhancementsReferences]
    };
  }
  return transformIn;
}