"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateCustomComponentTemplate = validateCustomComponentTemplate;
var _utils = require("../../../utils");
var _component_template_name = require("../../../../common/utils/component_template_name");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function validateCustomComponentTemplate({
  esClient,
  indexTemplateName
}) {
  const datasetQualityESClient = (0, _utils.createDatasetQualityESClient)(esClient);
  // cleaning the index template name as some have @template suffix
  const componentTemplateName = (0, _component_template_name.getComponentTemplatePrefixFromIndexTemplate)(indexTemplateName);
  try {
    const {
      index_templates: indexTemplates
    } = await datasetQualityESClient.indexTemplates({
      name: indexTemplateName
    });
    return indexTemplates.some(template => {
      var _template$index_templ;
      return (_template$index_templ = template.index_template.composed_of) === null || _template$index_templ === void 0 ? void 0 : _template$index_templ.includes(componentTemplateName + '@custom');
    });
  } catch (error) {
    return false;
  }
}