"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasetQualityDetailsLink = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _routerUtils = require("@kbn/router-utils");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/dataset_quality/table/dataset_quality_details_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DatasetQualityDetailsLink = exports.DatasetQualityDetailsLink = /*#__PURE__*/_react.default.memo(({
  urlService,
  dataStream,
  timeRange,
  children
}) => {
  const locator = urlService.locators.get(_deeplinksObservability.DATA_QUALITY_DETAILS_LOCATOR_ID);
  const datasetQualityUrl = locator === null || locator === void 0 ? void 0 : locator.getRedirectUrl({
    dataStream,
    timeRange
  });
  const navigateToDatasetQuality = () => {
    locator === null || locator === void 0 ? void 0 : locator.navigate({
      dataStream,
      timeRange
    });
  };
  const datasetQualityLinkDetailsProps = (0, _routerUtils.getRouterLinkProps)({
    href: datasetQualityUrl,
    onClick: navigateToDatasetQuality
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({}, datasetQualityLinkDetailsProps, {
    color: "primary",
    "data-test-subj": `datasetQualityTableDetailsLink-${dataStream}`,
    target: "_blank",
    size: "xs",
    flush: "both",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }), children);
});