"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = registerRoutes;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerRoutes(router, dataCatalog) {
  // GET /api/data_sources_registry/types
  router.get({
    path: '/api/data_sources_registry/types',
    validate: {},
    security: {
      authz: {
        enabled: false,
        reason: 'Not needed right now'
      }
    }
  }, async (context, request, response) => {
    const types = dataCatalog.list();
    return response.ok({
      body: types
    });
  });

  // GET /api/data_sources_registry/types/{id}
  router.get({
    path: '/api/data_sources_registry/types/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    },
    security: {
      authz: {
        enabled: false,
        reason: 'Not needed right now'
      }
    }
  }, async (context, request, response) => {
    try {
      const type = dataCatalog.get(request.params.id);
      if (!type) {
        return response.notFound({
          body: `Type ${request.params.id} not found`
        });
      }
      const workflowInfos = type.generateWorkflows('<fake-stack-connector-id>');
      return response.ok({
        body: {
          ...type,
          workflowInfos
        }
      });
    } catch (err) {
      return response.notFound({
        body: err.message
      });
    }
  });
}