"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataSourcesRegistryPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _data_catalog = require("./data_catalog");
var _routes = require("./routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DataSourcesRegistryPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "dataCatalog", void 0);
    this.logger = initializerContext.logger.get();
    this.dataCatalog = (0, _data_catalog.createDataCatalog)();
  }
  setup(core) {
    this.logger.debug('dataSourcesRegistry: Setup');
    const router = core.http.createRouter();
    (0, _routes.registerRoutes)(router, this.dataCatalog);
    return {
      register: dataType => this.dataCatalog.register(dataType)
    };
  }
  start(core) {
    this.logger.debug('dataSourcesRegistry: Started');
    const registeredTypes = this.dataCatalog.list();
    this.logger.debug(`DataTypeRegistry contents: ${JSON.stringify(registeredTypes, null, 2)}`);
    return {
      getCatalog: () => this.dataCatalog
    };
  }
  stop() {}
}
exports.DataSourcesRegistryPlugin = DataSourcesRegistryPlugin;