"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KIBANA_FEATURE = exports.ELASTICSEARCH_FEATURE = void 0;
var _coreApplicationCommon = require("@kbn/core-application-common");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _i18n = require("@kbn/i18n");
var _common = require("../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const degradedDocsAlertingFeatures = {
  ruleTypeId: _ruleDataUtils.DEGRADED_DOCS_RULE_TYPE_ID,
  consumers: [_ruleDataUtils.AlertConsumers.ALERTS]
};
const canManageRules = {
  groupType: 'independent',
  privileges: [{
    id: 'manage_rules',
    name: _i18n.i18n.translate('xpack.dataQuality.features.canManageRules', {
      defaultMessage: 'Manage rules'
    }),
    includeIn: 'all',
    alerting: {
      rule: {
        all: [degradedDocsAlertingFeatures]
      }
    },
    savedObject: {
      all: [],
      read: []
    },
    ui: ['alerting:save']
  }]
};
const canManageAlerts = {
  groupType: 'independent',
  privileges: [{
    id: 'manage_alerts',
    name: _i18n.i18n.translate('xpack.dataQuality.features.canManageAlerts', {
      defaultMessage: 'Manage alerts'
    }),
    includeIn: 'all',
    alerting: {
      alert: {
        all: [degradedDocsAlertingFeatures]
      }
    },
    savedObject: {
      all: [],
      read: []
    },
    ui: []
  }]
};
const KIBANA_FEATURE = exports.KIBANA_FEATURE = {
  id: _common.PLUGIN_FEATURE_ID,
  name: _common.PLUGIN_NAME,
  category: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.management,
  app: [_common.PLUGIN_ID],
  alerting: [degradedDocsAlertingFeatures],
  management: {
    insightsAndAlerting: ['triggersActions']
  },
  privileges: {
    all: {
      app: [_common.PLUGIN_ID],
      savedObject: {
        all: [],
        read: []
      },
      ui: ['show'],
      alerting: {
        rule: {
          read: [degradedDocsAlertingFeatures]
        },
        alert: {
          read: [degradedDocsAlertingFeatures]
        }
      },
      management: {
        insightsAndAlerting: ['triggersActions']
      }
    },
    read: {
      disabled: true,
      savedObject: {
        all: [],
        read: []
      },
      ui: ['show'],
      alerting: {
        rule: {
          read: [degradedDocsAlertingFeatures]
        },
        alert: {
          read: [degradedDocsAlertingFeatures]
        }
      }
    }
  },
  subFeatures: [{
    name: _i18n.i18n.translate('xpack.dataQuality.features.app.manageRules', {
      defaultMessage: 'Manage rules'
    }),
    description: _i18n.i18n.translate('xpack.dataQuality.features.app.manageRulesDescription', {
      defaultMessage: 'This feature enables users to manage dataset quality rules.'
    }),
    privilegeGroups: [canManageRules]
  }, {
    name: _i18n.i18n.translate('xpack.dataQuality.features.app.manageAlerts', {
      defaultMessage: 'Manage alerts'
    }),
    description: _i18n.i18n.translate('xpack.dataQuality.features.app.manageAlertsDescription', {
      defaultMessage: 'This feature enables users to manage dataset quality alerts.'
    }),
    privilegeGroups: [canManageAlerts]
  }]
};
const ELASTICSEARCH_FEATURE = exports.ELASTICSEARCH_FEATURE = {
  id: _common.PLUGIN_ID,
  management: {
    data: [_common.PLUGIN_ID]
  },
  privileges: [{
    ui: [],
    requiredClusterPrivileges: [],
    requiredIndexPrivileges: {
      ['logs-*-*']: ['read']
    }
  }, {
    ui: [],
    requiredClusterPrivileges: [],
    requiredIndexPrivileges: {
      ['traces-*-*']: ['read']
    }
  }, {
    ui: [],
    requiredClusterPrivileges: [],
    requiredIndexPrivileges: {
      ['metrics-*-*']: ['read']
    }
  }, {
    ui: [],
    requiredClusterPrivileges: [],
    requiredIndexPrivileges: {
      ['synthetics-*-*']: ['read']
    }
  }]
};