"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DATE_STRING_FORMAT = exports.ACTION = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DATE_STRING_FORMAT = exports.DATE_STRING_FORMAT = 'D MMM, YYYY, HH:mm:ss';

/**
 * Some properties are optional for a non-persisted Search Session.
 * This interface makes them mandatory, because management only shows persisted search sessions.
 */
let ACTION = exports.ACTION = /*#__PURE__*/function (ACTION) {
  ACTION["INSPECT"] = "inspect";
  ACTION["EXTEND"] = "extend";
  ACTION["DELETE"] = "delete";
  ACTION["RENAME"] = "rename";
  return ACTION;
}({});