"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getActions = getActions;
var _common = require("../../../../../../../common");
var _types = require("../../../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getActions(status) {
  const actions = [];
  actions.push(_types.ACTION.INSPECT);
  actions.push(_types.ACTION.RENAME);
  if (status === _common.SearchSessionStatus.IN_PROGRESS || status === _common.SearchSessionStatus.COMPLETE) {
    actions.push(_types.ACTION.EXTEND);
  }
  actions.push(_types.ACTION.DELETE);
  return actions;
}