"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchAbortController = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _common = require("@kbn/kibana-utils-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class SearchAbortController {
  constructor(timeout) {
    (0, _defineProperty2.default)(this, "inputAbortSignals", new Array());
    (0, _defineProperty2.default)(this, "abortController", new AbortController());
    (0, _defineProperty2.default)(this, "timeoutSub", void 0);
    (0, _defineProperty2.default)(this, "destroyed", false);
    (0, _defineProperty2.default)(this, "abortHandler", () => {
      const allAborted = this.inputAbortSignals.every(signal => signal.aborted);
      if (allAborted) {
        this.abortController.abort(this.inputAbortSignals[0].reason);
        this.cleanup();
      }
    });
    if (timeout) {
      this.timeoutSub = (0, _rxjs.timer)(timeout).subscribe(() => {
        this.abortController.abort(_common.AbortReason.TIMEOUT);
        this.timeoutSub.unsubscribe();
      });
    }
  }
  cleanup() {
    var _this$timeoutSub;
    if (this.destroyed) return;
    this.destroyed = true;
    (_this$timeoutSub = this.timeoutSub) === null || _this$timeoutSub === void 0 ? void 0 : _this$timeoutSub.unsubscribe();
    this.inputAbortSignals.forEach(abortSignal => {
      abortSignal.removeEventListener('abort', this.abortHandler);
    });
  }
  addAbortSignal(inputSignal) {
    if (this.destroyed) {
      return;
    }
    this.inputAbortSignals.push(inputSignal);
    if (inputSignal.aborted) {
      this.abortHandler();
    } else {
      // abort our internal controller if the input signal aborts
      inputSignal.addEventListener('abort', this.abortHandler);
    }
  }
  getSignal() {
    return this.abortController.signal;
  }
  abort(reason) {
    this.cleanup();
    this.abortController.abort(reason);
  }
  isTimeout() {
    return this.abortController.signal.reason === _common.AbortReason.TIMEOUT;
  }
  isCanceled() {
    return this.abortController.signal.reason === _common.AbortReason.CANCELED;
  }
}
exports.SearchAbortController = SearchAbortController;