"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AggsService = void 0;
exports.createGetConfig = createGetConfig;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _aggs = require("../../../common/search/aggs");
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Aggs needs synchronous access to specific uiSettings. Since settings can change
 * without a page refresh, we create a cache that subscribes to changes from
 * uiSettings.get$ and keeps everything up-to-date.
 *
 * @internal
 */
function createGetConfig(uiSettings, requiredSettings, subscriptions) {
  const settingsCache = {};
  requiredSettings.forEach(setting => {
    subscriptions.push(uiSettings.get$(setting).subscribe(value => {
      settingsCache[setting] = value;
    }));
  });
  return key => settingsCache[key];
}

/** @internal */

/** @internal */

/**
 * The aggs service provides a means of modeling and manipulating the various
 * Elasticsearch aggregations supported by Kibana, providing the ability to
 * output the correct DSL when you are ready to send your request to ES.
 */
class AggsService {
  constructor() {
    (0, _defineProperty2.default)(this, "aggsCommonService", new _aggs.AggsCommonService({
      shouldDetectTimeZone: true
    }));
    (0, _defineProperty2.default)(this, "getConfig", void 0);
    (0, _defineProperty2.default)(this, "subscriptions", []);
    (0, _defineProperty2.default)(this, "nowProvider", void 0);
    /**
     * NowGetter uses window.location, so we must have a separate implementation
     * of calculateBounds on the client and the server.
     */
    (0, _defineProperty2.default)(this, "calculateBounds", timeRange => (0, _common.calculateBounds)(timeRange, {
      forceNow: this.nowProvider.get()
    }));
  }
  setup({
    registerFunction,
    uiSettings,
    nowProvider
  }) {
    this.nowProvider = nowProvider;
    this.getConfig = createGetConfig(uiSettings, _aggs.aggsRequiredUiSettings, this.subscriptions);
    return this.aggsCommonService.setup({
      registerFunction
    });
  }
  start({
    dataViews,
    fieldFormats
  }) {
    const {
      calculateAutoTimeExpression,
      types,
      createAggConfigs
    } = this.aggsCommonService.start({
      getConfig: this.getConfig,
      getIndexPattern: dataViews.get,
      calculateBounds: this.calculateBounds,
      fieldFormats
    });
    return {
      calculateAutoTimeExpression,
      createAggConfigs,
      types
    };
  }
  stop() {
    this.subscriptions.forEach(s => s.unsubscribe());
    this.subscriptions = [];
  }
}
exports.AggsService = AggsService;