"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SerializableField = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Alias for unknown raw field value, could be instance of a field Class
 */

/**
 * Class to extends that enabled serializing and deserializing instance values
 */
class SerializableField {
  static isSerializable(field) {
    return Boolean(field.serialize);
  }

  /**
   * Serializes the class instance to a known `SerializedValue` that can be used to instantiate a new instance
   *
   * Ideally this returns the same params as found in the constructor.
   */

  /**
   * typescript forbids abstract static methods but this is a workaround to require it
   *
   * @param serializedValue type of `SerializedValue`
   * @returns `instanceValue` should same type as instantiating class
   */
  static deserialize(serializedValue) {
    throw new Error('Must implement a static `deserialize` method to conform to /`SerializableField/`');
  }
}
exports.SerializableField = SerializableField;