"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dataConnectorSchemaV1 = exports.dataConnectorMappings = exports.DATA_CONNECTOR_SAVED_OBJECT_TYPE = void 0;
exports.setupSavedObjects = setupSavedObjects;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DATA_CONNECTOR_SAVED_OBJECT_TYPE = exports.DATA_CONNECTOR_SAVED_OBJECT_TYPE = 'data_connector';
const dataConnectorSchemaV1 = exports.dataConnectorSchemaV1 = _configSchema.schema.object({
  name: _configSchema.schema.string(),
  type: _configSchema.schema.string(),
  config: _configSchema.schema.object({}),
  createdAt: _configSchema.schema.string(),
  updatedAt: _configSchema.schema.string(),
  features: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  workflowIds: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  toolIds: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  kscIds: _configSchema.schema.arrayOf(_configSchema.schema.string())
});
const dataConnectorMappings = exports.dataConnectorMappings = {
  dynamic: false,
  properties: {
    name: {
      type: 'text',
      fields: {
        keyword: {
          type: 'keyword'
        }
      }
    },
    type: {
      type: 'keyword'
    },
    workflowIds: {
      type: 'keyword'
    },
    toolIds: {
      type: 'keyword'
    },
    kscIds: {
      type: 'keyword'
    }
  }
};
function setupSavedObjects(savedObjects) {
  savedObjects.registerType({
    name: DATA_CONNECTOR_SAVED_OBJECT_TYPE,
    hidden: false,
    namespaceType: 'multiple-isolated',
    mappings: dataConnectorMappings,
    management: {
      displayName: 'Data Connector',
      defaultSearchField: 'name',
      importableAndExportable: true,
      getTitle(obj) {
        const attrs = obj.attributes;
        return `Data Connector[${attrs.name}]`;
      }
    },
    modelVersions: {
      1: {
        changes: [],
        schemas: {
          forwardCompatibility: dataConnectorSchemaV1.extends({}, {
            unknowns: 'ignore'
          }),
          create: dataConnectorSchemaV1
        }
      }
    }
  });
}